/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.Util;
import org.netbeans.modules.bugtracking.commons.FileToRepoMappingStorage;
import org.netbeans.modules.team.spi.TeamAccessorUtils;
import org.netbeans.modules.team.spi.TeamProject;
import org.netbeans.modules.versioning.util.VCSBugtrackingAccessor;

public class VCSBugtrackingSupportImpl
extends VCSBugtrackingAccessor {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.bridge");

    public void setFirmAssociations(File[] files, String url) {
        Repository repo;
        if (files == null) {
            throw new IllegalArgumentException("files is null");
        }
        if (files.length == 0) {
            return;
        }
        try {
            repo = VCSBugtrackingSupportImpl.getRepository(url);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "No issue tracker available for the given vcs url " + url, ex);
            return;
        }
        if (repo == null) {
            LOG.log(Level.WARNING, "No issue tracker available for the given vcs url {0}", url);
            return;
        }
        FileToRepoMappingStorage.getInstance().setFirmAssociation(org.netbeans.modules.bugtracking.commons.Util.getLargerContext((File)files[0]), repo.getUrl());
    }

    private static Repository getRepository(String repositoryUrl) throws IOException {
        TeamProject project = TeamAccessorUtils.getTeamProjectForRepository((String)repositoryUrl);
        return project != null ? Util.getTeamRepository((String)project.getHost(), (String)project.getName()) : null;
    }
}

