/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;

public class EngineContextProviderImpl
extends SourcePathProvider {
    private static final Logger LOGGER = Logger.getLogger(EngineContextProviderImpl.class.getName());
    private static boolean verbose = System.getProperty("netbeans.debugger.enginecontextproviderimpl") != null;
    private static final Set virtualFolders = new HashSet<String>(Arrays.asList("org", "org/apache", "org/apache/jsp", "jsp_servlet"));
    private final ContextProvider contextProvider;

    public EngineContextProviderImpl(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    public String getURL(String relativePath, boolean global) {
        SourcePathProvider provider;
        if (verbose) {
            System.out.println("ECPI(JSP): getURL " + relativePath + " global " + global);
        }
        if (relativePath == null || relativePath.endsWith(".java")) {
            return null;
        }
        if (virtualFolders.contains(relativePath) || relativePath.startsWith("org/apache/jsp")) {
            if (verbose) {
                System.out.println("ECPI(JSP):  fo virtual folder");
            }
            String userDir = System.getProperty("netbeans.user");
            try {
                if (userDir != null) {
                    File virtual = new File(userDir, "var" + File.separator + "virtual" + System.currentTimeMillis());
                    String url = virtual.toURI().toURL().toString();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Returning fake URL: " + url);
                    }
                    return url;
                }
            }
            catch (MalformedURLException virtual) {
                // empty catch block
            }
            String temp = System.getProperty("java.io.tmpdir");
            try {
                if (temp != null) {
                    File virtual = new File(temp, "virtual" + System.currentTimeMillis());
                    String url = virtual.toURI().toURL().toString();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Returning fake URL: " + url);
                    }
                    return url;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            LOGGER.log(Level.INFO, "Both netbeans.user and java.io.tmpdir properties are missing, returning null");
            return null;
        }
        if (relativePath.startsWith("jsp_servlet") && (provider = this.getDefaultContext()) != null) {
            String path = relativePath.substring(11);
            if ((path = path.replace("/_", "/")).startsWith("/")) {
                path = path.substring(1);
            }
            return provider.getURL(path, global);
        }
        return null;
    }

    private SourcePathProvider getDefaultContext() {
        List providers = this.contextProvider.lookup(null, SourcePathProvider.class);
        for (SourcePathProvider provider : providers) {
            if (provider == null || !provider.getClass().getName().equals("org.netbeans.modules.debugger.jpda.projects.SourcePathProviderImpl")) continue;
            return provider;
        }
        return null;
    }

    public String getRelativePath(String url, char directorySeparator, boolean includeExtension) {
        return null;
    }

    public String[] getOriginalSourceRoots() {
        return new String[0];
    }

    public String[] getSourceRoots() {
        return new String[0];
    }

    public void setSourceRoots(String[] sourceRoots) {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }
}

