/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.grunt.ui.options;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.javascript.grunt.exec.GruntExecutable;
import org.netbeans.modules.javascript.grunt.ui.options.Bundle;
import org.netbeans.modules.javascript.grunt.util.FileUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class GruntOptionsPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(GruntOptionsPanel.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel errorLabel;
    private JButton gruntBrowseButton;
    private JLabel gruntLabel;
    private JButton gruntSearchButton;
    private JTextField gruntTextField;
    private JLabel hintLabel;
    private JLabel installLabel;

    public GruntOptionsPanel() {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        this.init();
    }

    private void init() {
        this.errorLabel.setText(" ");
        this.hintLabel.setText(Bundle.GruntOptionsPanel_grunt_hint(GruntExecutable.GRUNT_NAME));
        this.gruntTextField.getDocument().addDocumentListener(new DefaultDocumentListener());
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public String getGrunt() {
        return this.gruntTextField.getText();
    }

    public void setGrunt(String grunt) {
        this.gruntTextField.setText(grunt);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.gruntLabel = new JLabel();
        this.gruntTextField = new JTextField();
        this.gruntBrowseButton = new JButton();
        this.gruntSearchButton = new JButton();
        this.hintLabel = new JLabel();
        this.installLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.gruntLabel.setLabelFor(this.gruntTextField);
        Mnemonics.setLocalizedText((JLabel)this.gruntLabel, (String)NbBundle.getMessage(GruntOptionsPanel.class, (String)"GruntOptionsPanel.gruntLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.gruntBrowseButton, (String)NbBundle.getMessage(GruntOptionsPanel.class, (String)"GruntOptionsPanel.gruntBrowseButton.text"));
        this.gruntBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GruntOptionsPanel.this.gruntBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.gruntSearchButton, (String)NbBundle.getMessage(GruntOptionsPanel.class, (String)"GruntOptionsPanel.gruntSearchButton.text"));
        this.gruntSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GruntOptionsPanel.this.gruntSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.hintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.installLabel, (String)NbBundle.getMessage(GruntOptionsPanel.class, (String)"GruntOptionsPanel.installLabel.text"));
        this.installLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GruntOptionsPanel.this.installLabelMousePressed(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                GruntOptionsPanel.this.installLabelMouseEntered(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.gruntLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.installLabel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.gruntTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gruntBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gruntSearchButton)))).addGroup(layout.createSequentialGroup().addComponent(this.errorLabel).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gruntLabel).addComponent(this.gruntTextField, -2, -1, -2).addComponent(this.gruntBrowseButton).addComponent(this.gruntSearchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hintLabel).addComponent(this.installLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void installLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void installLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://gruntjs.com/getting-started"));
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private void gruntBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(GruntOptionsPanel.class).setFilesOnly(true).setTitle(Bundle.GruntOptionsPanel_grunt_browse_title()).showOpenDialog();
        if (file != null) {
            this.gruntTextField.setText(file.getAbsolutePath());
        }
    }

    private void gruntSearchButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        Iterator<String> iterator = FileUtils.findFileOnUsersPath(GruntExecutable.GRUNT_NAME).iterator();
        if (iterator.hasNext()) {
            String grunt = iterator.next();
            this.gruntTextField.setText(new File(grunt).getAbsolutePath());
            return;
        }
        StatusDisplayer.getDefault().setStatusText(Bundle.GruntOptionsPanel_grunt_none());
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            GruntOptionsPanel.this.fireChange();
        }
    }
}

