/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.web.beans.xml.BeansAttributes;
import org.netbeans.modules.web.beans.xml.WebBeansComponent;
import org.netbeans.modules.web.beans.xml.WebBeansModel;
import org.netbeans.modules.web.beans.xml.WebBeansModelFactory;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CdiUtil {
    private static final Logger LOG = Logger.getLogger("org.netbeans.ui.metrics.cdi");
    public static final String BEANS = "beans";
    public static final String BEANS_XML = "beans.xml";
    private static final String META_INF = "META-INF";
    public static final String WEB_INF = "WEB-INF";
    private WeakReference<Project> myProject;
    private Set<String> myMessages;

    public CdiUtil(Project project) {
        this.myProject = new WeakReference<Project>(project);
        this.myMessages = new CopyOnWriteArraySet<String>();
    }

    public void log(String message, Class<?> clazz, Object[] params) {
        this.log(message, clazz, params, false);
    }

    public void log(String message, Class<?> clazz, Object[] params, boolean once) {
        if (!once) {
            if (this.myMessages.contains(message)) {
                return;
            }
            this.myMessages.add(message);
        }
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(LOG.getName());
        logRecord.setResourceBundle(NbBundle.getBundle(clazz));
        logRecord.setResourceBundleName(clazz.getPackage().getName() + ".Bundle");
        if (params != null) {
            logRecord.setParameters(params);
        }
        LOG.log(logRecord);
    }

    public static boolean isCdiEnabled(Project project) {
        return CdiUtil.getBeansXmlExists(project) != null || CdiUtil.isCdi11OrLater(project);
    }

    private static FileObject getBeansXmlExists(Project project) {
        Collection<FileObject> beansTargetFolder = CdiUtil.getBeansTargetFolder(project, false);
        for (FileObject fileObject : beansTargetFolder) {
            if (fileObject == null || fileObject.getFileObject(BEANS_XML) == null) continue;
            return fileObject.getFileObject(BEANS_XML);
        }
        return null;
    }

    private FileObject getBeansXmlExists() {
        Collection<FileObject> beansTargetFolder = this.getBeansTargetFolder(false);
        for (FileObject fileObject : beansTargetFolder) {
            if (fileObject == null || fileObject.getFileObject(BEANS_XML) == null) continue;
            return fileObject.getFileObject(BEANS_XML);
        }
        return null;
    }

    public boolean isCdiEnabled() {
        Project project = this.getProject();
        if (project == null) {
            return false;
        }
        Collection<FileObject> beansTargetFolder = this.getBeansTargetFolder(false);
        for (FileObject fileObject : beansTargetFolder) {
            if (fileObject == null || fileObject.getFileObject(BEANS_XML) == null) continue;
            return true;
        }
        return this.isCdi11OrLater();
    }

    public static boolean isCdi11OrLater(Project p) {
        if (!CdiUtil.hasResource(p, "javax/enterprise/inject/spi/AfterTypeDiscovery.class") && !CdiUtil.hasResource(p, "jakarta/enterprise/inject/spi/AfterTypeDiscovery.class")) {
            return false;
        }
        FileObject beans = CdiUtil.getBeansXmlExists(p);
        if (beans == null) {
            return true;
        }
        WebBeansModel model = WebBeansModelFactory.getInstance().getModel(CdiUtil.getModelSource(beans, true));
        if (model == null) {
            return false;
        }
        String attribute = ((WebBeansComponent)model.getRootComponent()).getAttribute(BeansAttributes.VERSION);
        return attribute != null && !attribute.equals("1.0");
    }

    public boolean isCdi11OrLater() {
        if (!CdiUtil.hasResource(this.getProject(), "javax/enterprise/inject/spi/AfterTypeDiscovery.class") && !CdiUtil.hasResource(this.getProject(), "jakarta/enterprise/inject/spi/AfterTypeDiscovery.class")) {
            return false;
        }
        FileObject beans = this.getBeansXmlExists();
        if (beans == null) {
            return true;
        }
        WebBeansModel model = WebBeansModelFactory.getInstance().getModel(CdiUtil.getModelSource(beans, true));
        if (model == null || model.getRootComponent() == null) {
            return false;
        }
        String attribute = ((WebBeansComponent)model.getRootComponent()).getAttribute(BeansAttributes.XMLNS);
        String version = ((WebBeansComponent)model.getRootComponent()).getAttribute(BeansAttributes.VERSION);
        if (attribute != null && attribute.startsWith("http://java")) {
            return false;
        }
        return !"1.0".equals(version);
    }

    private static ModelSource getModelSource(FileObject fileObject, boolean isEditable) {
        try {
            return Utilities.createModelSource((FileObject)fileObject, (boolean)isEditable);
        }
        catch (CatalogModelException ex) {
            Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    private static boolean hasResource(Project project, String resource) {
        SourceGroup[] sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sgs.length < 1) {
            return false;
        }
        FileObject sourceRoot = sgs[0].getRootFolder();
        ClassPath classPath = ClassPath.getClassPath((FileObject)sourceRoot, (String)"classpath/compile");
        if (classPath == null) {
            return false;
        }
        FileObject resourceFile = classPath.findResource(resource);
        return resourceFile != null;
    }

    public Collection<FileObject> getBeansTargetFolder(boolean create) {
        Project project = this.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        return CdiUtil.getBeansTargetFolder(project, create);
    }

    protected Project getProject() {
        return (Project)this.myProject.get();
    }

    @CheckForNull
    public FileObject enableCdi() {
        Collection<FileObject> infs = this.getBeansTargetFolder(true);
        for (FileObject inf : infs) {
            if (inf == null) continue;
            FileObject beansXml = inf.getFileObject(BEANS_XML);
            if (beansXml != null) {
                return null;
            }
            try {
                EjbJar ejbJar = EjbJar.getEjbJar((FileObject)((Project)this.myProject.get()).getProjectDirectory());
                Profile profile = ejbJar != null ? ejbJar.getJ2eeProfile() : Profile.JAVA_EE_6_WEB;
                LOG.log(Level.INFO, "Creating beans.xml file for project: {0}", ((Project)this.myProject.get()).getProjectDirectory());
                return DDHelper.createBeansXml((Profile)profile, (FileObject)inf, (String)BEANS);
            }
            catch (IOException exception) {
                Exceptions.printStackTrace((Throwable)exception);
                return null;
            }
        }
        return null;
    }

    public static Collection<FileObject> getBeansTargetFolder(Project project, boolean create) {
        FileObject fileObject;
        Sources sources = ProjectUtils.getSources((Project)project);
        ArrayList<FileObject> result = new ArrayList<FileObject>(2);
        SourceGroup[] sourceGroups = sources.getSourceGroups("resources");
        if (sourceGroups != null && sourceGroups.length > 0) {
            fileObject = CdiUtil.getDefaultBeansTargetFolder(sourceGroups, false);
            if (fileObject != null) {
                result.add(fileObject);
            }
        } else {
            sourceGroups = sources.getSourceGroups("java");
            fileObject = CdiUtil.getDefaultBeansTargetFolder(sourceGroups, false);
            if (fileObject != null) {
                result.add(fileObject);
            }
        }
        if (result.isEmpty() && create) {
            SourceGroup resourcesSourceGroup = SourceGroupModifier.createSourceGroup((Project)project, (String)"resources", (String)"main");
            if (resourcesSourceGroup != null) {
                sourceGroups = new SourceGroup[]{resourcesSourceGroup};
            }
            FileObject fileObject2 = CdiUtil.getDefaultBeansTargetFolder(sourceGroups, true);
            result.add(fileObject2);
        }
        return result;
    }

    private static FileObject getDefaultBeansTargetFolder(SourceGroup[] sourceGroups, boolean create) {
        if (sourceGroups.length > 0) {
            FileObject metaInf = sourceGroups[0].getRootFolder().getFileObject(META_INF);
            if (metaInf == null && create) {
                try {
                    metaInf = FileUtil.createFolder((FileObject)sourceGroups[0].getRootFolder(), (String)META_INF);
                }
                catch (IOException e) {
                    Logger.getLogger(CdiUtil.class.getName()).log(Level.WARNING, null, e);
                }
            }
            return metaInf;
        }
        return null;
    }
}

