/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.callstack;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.javascript.debugger.MiscEditorUtil;
import org.netbeans.modules.web.javascript.debugger.annotation.CallStackAnnotation;
import org.netbeans.modules.web.javascript.debugger.annotation.CurrentLineAnnotation;
import org.netbeans.modules.web.javascript.debugger.browser.ProjectContext;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.Script;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;

public class CallStackAnnotationListener
extends DebuggerManagerAdapter
implements PropertyChangeListener {
    private ProjectContext pc;
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final Map<Debugger, Debugger.Listener> debuggerListeners = new HashMap<Debugger, Debugger.Listener>();

    public String[] getProperties() {
        return new String[]{"debuggerEngines", "currentEngine"};
    }

    public void engineAdded(DebuggerEngine engine) {
        Debugger d = (Debugger)engine.lookupFirst("", Debugger.class);
        if (d != null) {
            this.addDebuggerListener(d);
            d.addPropertyChangeListener((PropertyChangeListener)this);
            this.pc = (ProjectContext)engine.lookupFirst(null, ProjectContext.class);
            List stackTrace = d.isSuspended() ? d.getCurrentCallStack() : Collections.emptyList();
            this.updateAnnotations(d, stackTrace);
        }
    }

    public void engineRemoved(DebuggerEngine engine) {
        Debugger d = (Debugger)engine.lookupFirst("", Debugger.class);
        if (d != null) {
            this.removeDebuggerListener(d);
            d.removePropertyChangeListener((PropertyChangeListener)this);
            this.pc = null;
            this.updateAnnotations(null, Collections.emptyList());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Debugger d;
        DebuggerEngine engine;
        Script script;
        CallFrame cf;
        String propertyName = evt.getPropertyName();
        if ("currentFrame".equals(propertyName) && (cf = (CallFrame)evt.getNewValue()) != null && (script = cf.getScript()) != null) {
            Project project = this.pc != null ? this.pc.getProject() : null;
            Debugger d2 = (Debugger)evt.getSource();
            Line line = MiscEditorUtil.getLine(d2, project, script, cf.getLineNumber(), cf.getColumnNumber());
            MiscEditorUtil.showLine(line, true);
        }
        if ("currentEngine".equals(propertyName) && (engine = (DebuggerEngine)evt.getNewValue()) != null && (d = (Debugger)engine.lookupFirst("", Debugger.class)) != null) {
            this.pc = (ProjectContext)engine.lookupFirst(null, ProjectContext.class);
            List stackTrace = d.isSuspended() ? d.getCurrentCallStack() : Collections.emptyList();
            this.updateAnnotations(d, stackTrace);
        }
    }

    private void updateAnnotations(Debugger d, List<CallFrame> stackTrace) {
        for (Annotation ann : this.annotations) {
            ann.detach();
        }
        this.annotations.clear();
        boolean first = true;
        for (CallFrame cf : stackTrace) {
            Annotation anno;
            Script script = cf.getScript();
            if (script == null) continue;
            Project project = this.pc != null ? this.pc.getProject() : null;
            Line line = MiscEditorUtil.getLine(d, project, script, cf.getLineNumber(), cf.getColumnNumber());
            if (line == null) {
                first = false;
                continue;
            }
            if (first) {
                anno = new CurrentLineAnnotation((Annotatable)line);
                MiscEditorUtil.showLine(line, true);
                first = false;
            } else {
                anno = new CallStackAnnotation((Annotatable)line);
            }
            this.annotations.add(anno);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDebuggerListener(Debugger d) {
        DebuggerAnnotationsListener l = new DebuggerAnnotationsListener(d);
        Map<Debugger, Debugger.Listener> map = this.debuggerListeners;
        synchronized (map) {
            this.debuggerListeners.put(d, l);
        }
        d.addListener((Debugger.Listener)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDebuggerListener(Debugger d) {
        Debugger.Listener l;
        Map<Debugger, Debugger.Listener> map = this.debuggerListeners;
        synchronized (map) {
            l = this.debuggerListeners.remove(d);
        }
        if (l != null) {
            d.removeListener(l);
        }
    }

    private class DebuggerAnnotationsListener
    implements Debugger.Listener {
        private final Debugger d;

        private DebuggerAnnotationsListener(Debugger d) {
            this.d = d;
        }

        public void paused(List<CallFrame> callStack, String reason) {
            CallStackAnnotationListener.this.updateAnnotations(this.d, callStack);
        }

        public void resumed() {
            CallStackAnnotationListener.this.updateAnnotations(null, Collections.emptyList());
        }

        public void reset() {
        }

        public void enabled(boolean enabled) {
        }
    }
}

