/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.scrolling;

import java.awt.Adjustable;
import java.awt.Point;
import org.netbeans.jemmy.drivers.scrolling.AWTScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ScrollPaneOperator;

public class ScrollPaneDriver
extends AWTScrollDriver {
    private static final int CLICK_OFFSET = 5;

    public ScrollPaneDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.ScrollPaneOperator"});
    }

    @Override
    protected int position(ComponentOperator oper, int orientation) {
        return orientation == 0 ? ((ScrollPaneOperator)oper).getScrollPosition().x : ((ScrollPaneOperator)oper).getScrollPosition().y;
    }

    @Override
    public void scrollToMinimum(ComponentOperator oper, final int orientation) {
        final Adjustable adj = orientation == 0 ? ((ScrollPaneOperator)oper).getHAdjustable() : ((ScrollPaneOperator)oper).getVAdjustable();
        this.scroll(oper, new ScrollAdjuster(){

            @Override
            public int getScrollDirection() {
                return adj.getMinimum() < adj.getValue() ? -1 : 0;
            }

            @Override
            public int getScrollOrientation() {
                return orientation;
            }

            @Override
            public String getDescription() {
                return "Scroll to minimum";
            }
        });
    }

    @Override
    public void scrollToMaximum(ComponentOperator oper, final int orientation) {
        final Adjustable adj = orientation == 0 ? ((ScrollPaneOperator)oper).getHAdjustable() : ((ScrollPaneOperator)oper).getVAdjustable();
        this.scroll(oper, new ScrollAdjuster(){

            @Override
            public int getScrollDirection() {
                return adj.getMaximum() - adj.getVisibleAmount() > adj.getValue() ? 1 : 0;
            }

            @Override
            public int getScrollOrientation() {
                return orientation;
            }

            @Override
            public String getDescription() {
                return "Scroll to maximum";
            }
        });
    }

    @Override
    protected Point getClickPoint(ComponentOperator oper, int direction, int orientation) {
        int y;
        int x;
        if (orientation == 0) {
            int offset;
            int n = offset = ((ScrollPaneOperator)oper).isScrollbarVisible(1) ? ((ScrollPaneOperator)oper).getVScrollbarWidth() : 0;
            if (direction == 1) {
                x = oper.getWidth() - 1 - 5 - offset;
            } else if (direction == -1) {
                x = 5;
            } else {
                return null;
            }
            y = oper.getHeight() - ((ScrollPaneOperator)oper).getHScrollbarHeight() / 2;
        } else if (orientation == 1) {
            int offset;
            int n = offset = ((ScrollPaneOperator)oper).isScrollbarVisible(0) ? ((ScrollPaneOperator)oper).getHScrollbarHeight() : 0;
            if (direction == 1) {
                y = oper.getHeight() - 1 - 5 - offset;
            } else if (direction == -1) {
                y = 5;
            } else {
                return null;
            }
            x = oper.getWidth() - ((ScrollPaneOperator)oper).getVScrollbarWidth() / 2;
        } else {
            return null;
        }
        return new Point(x, y);
    }
}

