/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.installations;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.db.mysql.impl.Installation;
import org.netbeans.modules.db.mysql.impl.MultiInstallation;
import org.netbeans.modules.db.mysql.installations.WindowsStandaloneInstallation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class WindowsStandaloneMultiInstallation
implements MultiInstallation {
    private static final WindowsStandaloneMultiInstallation DEFAULT = new WindowsStandaloneMultiInstallation();
    private Collection<Installation> installations = null;

    @Override
    public Collection<Installation> getInstallations() {
        if (!Utilities.isWindows()) {
            return Collections.emptyList();
        }
        if (this.installations != null) {
            return this.installations;
        }
        FileObject fo = FileUtil.toFileObject((File)WindowsStandaloneInstallation.DEFAULT_BASE_PATH);
        if (fo != null) {
            ArrayList<Installation> found = new ArrayList<Installation>(3);
            for (FileObject child : fo.getChildren()) {
                if (!child.getNameExt().startsWith("MySQL Server ") || !child.isFolder()) continue;
                found.add(new WindowsStandaloneInstallation(child.getNameExt()));
            }
            this.installations = found;
        } else {
            this.installations = Collections.emptyList();
        }
        return this.installations;
    }

    @Override
    public void refresh() {
        this.installations = null;
    }

    public static WindowsStandaloneMultiInstallation getDefault() {
        return DEFAULT;
    }
}

