/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.netbeans.modules.languages.yaml.YamlStructureItem;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class YamlSemanticAnalyzer
extends SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        YamlParserResult ypr = (YamlParserResult)result;
        if (ypr == null || ypr.getItems().isEmpty()) {
            this.semanticHighlights = Collections.emptyMap();
            return;
        }
        HashMap<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        for (StructureItem structureItem : ypr.getItems()) {
            YamlStructureItem yamlItem = (YamlStructureItem)structureItem;
            this.addHighlights(yamlItem, highlights);
        }
        this.semanticHighlights = highlights;
    }

    private void addHighlights(YamlStructureItem item, Map<OffsetRange, Set<ColoringAttributes>> highlights) {
        switch (item.getType()) {
            case MAP: 
            case SEQUENCE: {
                YamlStructureItem.Collection coll = (YamlStructureItem.Collection)item;
                for (YamlStructureItem yamlStructureItem : coll.getChildren()) {
                    this.addHighlights(yamlStructureItem, highlights);
                }
                break;
            }
            case MAPPING: {
                YamlStructureItem.MapEntry entry = (YamlStructureItem.MapEntry)item;
                if (entry.keyItem.getType() == YamlStructureItem.NodeType.SCALAR) {
                    highlights.put(YamlSemanticAnalyzer.getAstRange(entry.keyItem), ColoringAttributes.METHOD_SET);
                } else {
                    this.addHighlights(entry.keyItem, highlights);
                }
                this.addHighlights(entry.valueItem, highlights);
            }
        }
    }

    private static OffsetRange getAstRange(YamlStructureItem item) {
        int s = (int)item.getPosition();
        int e = (int)item.getEndPosition();
        return new OffsetRange(s, e);
    }
}

