/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.jade.editor;

import java.net.URL;
import java.util.Collections;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.lib.api.HelpItem;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

public class JadeCompletionItem
implements CompletionProposal {
    protected final CompletionRequest request;
    protected final ElementHandle element;

    public static CompletionProposal create(CompletionRequest request, HtmlTag tag) {
        HtmlTagElement element = new HtmlTagElement(tag);
        return new JadeCompletionItem(request, element);
    }

    public static CompletionProposal create(CompletionRequest request, HtmlTagAttribute attribute) {
        HtmlTagAttributeElement element = new HtmlTagAttributeElement(attribute);
        return new JadeCompletionItem(request, element);
    }

    public static CompletionProposal createCssItem(CompletionRequest request, String name, String cssPrefix) {
        SimpleElement element = new SimpleElement(name, ElementKind.RULE);
        return new CssItem(request, element, cssPrefix);
    }

    public JadeCompletionItem(CompletionRequest request, ElementHandle element) {
        this.request = request;
        this.element = element;
    }

    public int getAnchorOffset() {
        return this.request.anchor;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.getName();
    }

    public String getSortText() {
        return this.getName();
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        formatter.appendText(this.getName());
        return formatter.getText();
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        return null;
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        Set emptyModifiers = Collections.emptySet();
        ElementHandle handle = this.getElement();
        return handle != null ? handle.getModifiers() : emptyModifiers;
    }

    public boolean isSmart() {
        return false;
    }

    public int getSortPrioOverride() {
        return 200;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    public static class HtmlTagElement
    extends SimpleElement {
        final HtmlTag tag;

        public HtmlTagElement(HtmlTag tag) {
            super(tag.getName(), ElementKind.TAG);
            this.tag = tag;
        }

        @Override
        public Documentation getDocumentation() {
            HelpItem help = this.tag.getHelp();
            if (help != null) {
                String content;
                if (help.getHelpContent() != null) {
                    if (help.getHelpURL() != null) {
                        return Documentation.create((String)help.getHelpContent(), (URL)help.getHelpURL());
                    }
                    return Documentation.create((String)help.getHelpContent());
                }
                if (help.getHelpResolver() != null && help.getHelpURL() != null && (content = help.getHelpResolver().getHelpContent(help.getHelpURL())) != null) {
                    return Documentation.create((String)content, (URL)help.getHelpURL());
                }
            }
            return null;
        }
    }

    protected static class CompletionRequest {
        public final int anchor;
        public final String prefix;
        public final ParserResult parserResult;

        public CompletionRequest(ParserResult parserResult, int anchor, String prefix) {
            this.anchor = anchor;
            this.prefix = prefix;
            this.parserResult = parserResult;
        }
    }

    public static class HtmlTagAttributeElement
    extends SimpleElement {
        final HtmlTagAttribute attribute;

        public HtmlTagAttributeElement(HtmlTagAttribute attribute) {
            super(attribute.getName(), ElementKind.ATTRIBUTE);
            this.attribute = attribute;
        }

        @Override
        public Documentation getDocumentation() {
            HelpItem help = this.attribute.getHelp();
            if (help != null) {
                String content;
                if (help.getHelpContent() != null) {
                    if (help.getHelpURL() != null) {
                        return Documentation.create((String)help.getHelpContent(), (URL)help.getHelpURL());
                    }
                    return Documentation.create((String)help.getHelpContent());
                }
                if (help.getHelpResolver() != null && help.getHelpURL() != null && (content = help.getHelpResolver().getHelpContent(help.getHelpURL())) != null) {
                    return Documentation.create((String)content, (URL)help.getHelpURL());
                }
            }
            return null;
        }
    }

    public static class SimpleElement
    implements ElementHandle {
        private final String name;
        private final ElementKind kind;

        public SimpleElement(String name, ElementKind kind) {
            this.name = name;
            this.kind = kind;
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return "";
        }

        public String getName() {
            return this.name;
        }

        public String getIn() {
            return "";
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }

        public Documentation getDocumentation() {
            return null;
        }
    }

    static class CssItem
    extends JadeCompletionItem {
        private final String cssPrefix;

        public CssItem(CompletionRequest request, ElementHandle element, String cssPrefix) {
            super(request, element);
            this.cssPrefix = cssPrefix;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.appendText(this.cssPrefix);
            formatter.appendText(this.getName());
            return formatter.getText();
        }
    }

    static class KeywordItem
    extends JadeCompletionItem {
        private static ImageIcon keywordIcon = null;
        private String keyword = null;

        public KeywordItem(String keyword, CompletionRequest request) {
            super(request, null);
            this.keyword = keyword;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            return formatter.getText();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            return null;
        }

        @Override
        public ImageIcon getIcon() {
            if (keywordIcon == null) {
                keywordIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/jade/resources/jade16.png"));
            }
            return keywordIcon;
        }

        @Override
        public String getInsertPrefix() {
            return this.getName();
        }

        @Override
        public String getCustomInsertTemplate() {
            return this.getName();
        }

        @Override
        public int getSortPrioOverride() {
            return 130;
        }
    }
}

