/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.spring.beans.completion.OptionCodeCompletionSettings;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.openide.util.Exceptions;

public final class CompletorUtils {
    public static final Acceptor JAVA_IDENTIFIER_ACCEPTOR = new Acceptor(){

        @Override
        public boolean accept(String str) {
            for (char c : str.toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) continue;
                return false;
            }
            return true;
        }
    };
    public static final Acceptor CHARACTER_STRING_ACCEPTOR = new Acceptor(){

        @Override
        public boolean accept(String str) {
            for (char c : str.toCharArray()) {
                if (Character.isLetter(c)) continue;
                return false;
            }
            return true;
        }
    };
    public static final Acceptor BEAN_NAME_ACCEPTOR = new Acceptor(){

        @Override
        public boolean accept(String str) {
            for (char c : str.toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) continue;
                return false;
            }
            return true;
        }
    };
    public static final Acceptor RESOURCE_PATH_ELEMENT_ACCEPTOR = new Acceptor(){

        @Override
        public boolean accept(String str) {
            return !str.contains("/");
        }
    };
    public static final Acceptor P_ATTRIBUTE_ACCEPTOR = new Acceptor(){

        @Override
        public boolean accept(String str) {
            for (char c : str.toCharArray()) {
                if (Character.isWhitespace(c)) {
                    return false;
                }
                if (Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == ':') continue;
                return false;
            }
            return true;
        }
    };

    private CompletorUtils() {
    }

    public static boolean canFilter(Document doc, int invocationOffset, int caretOffset, int anchorOffset, Acceptor acceptor) {
        if (anchorOffset == -1 || caretOffset < invocationOffset) {
            return false;
        }
        try {
            String prefix = doc.getText(anchorOffset, caretOffset - anchorOffset);
            return acceptor.accept(prefix);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    public static List<SpringXMLConfigCompletionItem> filter(List<SpringXMLConfigCompletionItem> cachedItems, Document doc, int invocationOffset, int caretOffset, int anchorOffset) {
        if (anchorOffset == -1) {
            return Collections.emptyList();
        }
        ArrayList<SpringXMLConfigCompletionItem> filteredItems = new ArrayList();
        try {
            String prefix = doc.getText(anchorOffset, caretOffset - anchorOffset);
            for (SpringXMLConfigCompletionItem item : cachedItems) {
                if (!item.getInsertPrefix().toString().regionMatches(!OptionCodeCompletionSettings.isCaseSensitive(), 0, prefix, 0, caretOffset - anchorOffset)) continue;
                filteredItems.add(item);
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            filteredItems = Collections.emptyList();
        }
        return filteredItems;
    }

    public static interface Acceptor {
        public boolean accept(String var1);
    }
}

