/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.ScannerList;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.PushTaskScanner;

public abstract class ScannerDescriptor
implements Comparable<ScannerDescriptor> {
    public abstract String getType();

    public abstract String getDisplayName();

    public abstract String getDescription();

    public abstract String getOptionsPath();

    @Override
    public int compareTo(ScannerDescriptor sd) {
        return this.getDisplayName().compareTo(sd.getDisplayName());
    }

    public static String getType(FileTaskScanner scanner) {
        return scanner.getClass().getName();
    }

    public static String getType(PushTaskScanner scanner) {
        return scanner.getClass().getName();
    }

    public static List<? extends ScannerDescriptor> getDescriptors() {
        List<FileTaskScanner> fileScanners = ScannerList.getFileScannerList().getScanners();
        List<PushTaskScanner> simpleScanners = ScannerList.getPushScannerList().getScanners();
        ArrayList<ScannerDescriptor> res = new ArrayList<ScannerDescriptor>(fileScanners.size() + simpleScanners.size());
        for (FileTaskScanner fileTaskScanner : fileScanners) {
            res.add(new FileDescriptor(fileTaskScanner));
        }
        for (PushTaskScanner pushTaskScanner : simpleScanners) {
            res.add(new PushDescriptor(pushTaskScanner));
        }
        Collections.sort(res);
        return res;
    }

    private static class FileDescriptor
    extends ScannerDescriptor {
        private FileTaskScanner scanner;

        public FileDescriptor(FileTaskScanner scanner) {
            assert (null != scanner);
            this.scanner = scanner;
        }

        @Override
        public String getDisplayName() {
            return Accessor.getDisplayName(this.scanner);
        }

        @Override
        public String getDescription() {
            return Accessor.getDescription(this.scanner);
        }

        @Override
        public String getOptionsPath() {
            return Accessor.getOptionsPath(this.scanner);
        }

        @Override
        public String getType() {
            return FileDescriptor.getType(this.scanner);
        }
    }

    private static class PushDescriptor
    extends ScannerDescriptor {
        private PushTaskScanner scanner;

        public PushDescriptor(PushTaskScanner scanner) {
            assert (null != scanner);
            this.scanner = scanner;
        }

        @Override
        public String getDisplayName() {
            return Accessor.getDisplayName(this.scanner);
        }

        @Override
        public String getDescription() {
            return Accessor.getDescription(this.scanner);
        }

        @Override
        public String getOptionsPath() {
            return Accessor.getOptionsPath(this.scanner);
        }

        @Override
        public String getType() {
            return PushDescriptor.getType(this.scanner);
        }
    }
}

