/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.suggestions.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class Move {
    public static ErrorDescription moveInitialization(HintContext ctx) {
        TreePath path = ctx.getPath();
        Tree.Kind parentKind = path.getParentPath().getLeaf().getKind();
        if (parentKind != Tree.Kind.CLASS || path.getLeaf().getKind() != Tree.Kind.VARIABLE) {
            return null;
        }
        VariableTree var = (VariableTree)path.getLeaf();
        if (var.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
            return null;
        }
        String displayName = Bundle.FIX_moveInitialization();
        Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath()).toEditorFix();
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{fix});
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_moveInitialization();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            TreePath tp = ctx.getPath();
            TreePath parentPath = tp.getParentPath();
            ClassTree parent = (ClassTree)parentPath.getLeaf();
            VariableTree var = (VariableTree)tp.getLeaf();
            WorkingCopy wc = ctx.getWorkingCopy();
            TreeMaker make = wc.getTreeMaker();
            HashMap<StatementTree, StatementTree> original2translated = new HashMap<StatementTree, StatementTree>();
            ClassTree translated = parent;
            VariableTree newVar = make.Variable(var.getModifiers(), (CharSequence)var.getName(), var.getType(), null);
            original2translated.put(var, newVar);
            List<? extends Tree> members = parent.getMembers();
            for (Tree tree : members) {
                if (tree.getKind() != Tree.Kind.METHOD || !((MethodTree)tree).getName().contentEquals("<init>")) continue;
                MethodTree method = (MethodTree)tree;
                boolean synthetic = wc.getTreeUtilities().isSynthetic(new TreePath(parentPath, tree));
                boolean isStatic = var.getModifiers().getFlags().contains((Object)Modifier.STATIC);
                BlockTree body = method.getBody();
                if (body == null) continue;
                LinkedList<? extends StatementTree> statements = new LinkedList<StatementTree>(body.getStatements());
                statements.add(1, make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)make.Identifier((CharSequence)((isStatic ? parent.getSimpleName().toString() : "this") + "." + var.getName())), this.transformInitializer(var.getInitializer(), var.getType(), make))));
                if (synthetic) {
                    Tree constructor = parentPath.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS ? make.Block(Collections.singletonList((StatementTree)statements.get(1)), false) : make.Constructor(make.Modifiers(method.getModifiers().getFlags(), method.getModifiers().getAnnotations()), method.getTypeParameters(), method.getParameters(), method.getThrows(), make.Block(statements, false));
                    translated = GeneratorUtilities.get((WorkingCopy)wc).insertClassMember(translated, constructor);
                    continue;
                }
                original2translated.put(body, make.Block(statements, false));
            }
            translated = (ClassTree)wc.getTreeUtilities().translate((Tree)translated, original2translated);
            wc.rewrite((Tree)parent, (Tree)translated);
        }

        private ExpressionTree transformInitializer(ExpressionTree initializer, Tree type, TreeMaker make) {
            NewArrayTree nat;
            if (initializer.getKind() == Tree.Kind.NEW_ARRAY && (nat = (NewArrayTree)initializer).getType() == null) {
                if (type.getKind() == Tree.Kind.ARRAY_TYPE) {
                    ArrayTypeTree arrayTypeTree = (ArrayTypeTree)type;
                    type = arrayTypeTree.getType();
                }
                return make.NewArray(type, nat.getDimensions(), nat.getInitializers());
            }
            return initializer;
        }
    }
}

