/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.ConvertToLambdaConverter;
import org.netbeans.modules.java.hints.suggestions.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.util.NbBundle;

public class Lambda {
    private static final String[] LAMBDA_PARAMETER_ERROR_CODES = new String[]{"compiler.err.invalid.lambda.parameter.declaration"};

    public static ErrorDescription lambda2Class(HintContext ctx) {
        TypeMirror samType = ctx.getInfo().getTrees().getTypeMirror(ctx.getPath());
        if (samType == null || samType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_lambda2Class(), (Fix[])new Fix[]{new Lambda2Anonymous(ctx.getInfo(), ctx.getPath()).toEditorFix()});
    }

    public static ErrorDescription lambda2MemberReference(HintContext ctx) {
        ExpressionTree expr;
        TypeMirror samType = ctx.getInfo().getTrees().getTypeMirror(ctx.getPath());
        if (samType == null || samType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        LambdaExpressionTree lambda = (LambdaExpressionTree)ctx.getPath().getLeaf();
        Tree tree = lambda.getBody();
        if (tree == null) {
            return null;
        }
        if (tree.getKind() == Tree.Kind.BLOCK) {
            if (((BlockTree)tree).getStatements().size() == 1) {
                if ((tree = (Tree)((BlockTree)tree).getStatements().get(0)).getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
                    tree = ((ExpressionStatementTree)tree).getExpression();
                } else if (tree.getKind() == Tree.Kind.RETURN) {
                    tree = ((ReturnTree)tree).getExpression();
                } else {
                    return null;
                }
                if (tree == null) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (tree.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return null;
        }
        boolean check = true;
        Iterator<? extends VariableTree> paramsIt = lambda.getParameters().iterator();
        ExpressionTree methodSelect = ((MethodInvocationTree)tree).getMethodSelect();
        if (paramsIt.hasNext() && methodSelect.getKind() == Tree.Kind.MEMBER_SELECT && (expr = ((MemberSelectTree)methodSelect).getExpression()).getKind() == Tree.Kind.IDENTIFIER && !((IdentifierTree)expr).getName().contentEquals(paramsIt.next().getName())) {
            paramsIt = lambda.getParameters().iterator();
        }
        Iterator<? extends ExpressionTree> argsIt = ((MethodInvocationTree)tree).getArguments().iterator();
        while (check && argsIt.hasNext() && paramsIt.hasNext()) {
            ExpressionTree arg = argsIt.next();
            if (arg.getKind() == Tree.Kind.IDENTIFIER && paramsIt.next().getName().contentEquals(((IdentifierTree)arg).getName())) continue;
            check = false;
        }
        if (!check || paramsIt.hasNext() || argsIt.hasNext()) {
            return null;
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_lambda2MemberReference(), (Fix[])new Fix[]{new Lambda2MemberReference(ctx.getInfo(), ctx.getPath()).toEditorFix()});
    }

    public static ErrorDescription expression2Return(HintContext ctx) {
        if (((LambdaExpressionTree)ctx.getPath().getLeaf()).getBodyKind() != LambdaExpressionTree.BodyKind.EXPRESSION) {
            return null;
        }
        TypeMirror lambdaExpressionType = ctx.getInfo().getTrees().getTypeMirror((TreePath)ctx.getVariables().get("$lambdaExpression"));
        String target = lambdaExpressionType == null || lambdaExpressionType.getKind() != TypeKind.VOID ? "($args$) -> { return $lambdaExpression; }" : "($args$) -> { $lambdaExpression; }";
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_expression2Return(), (Fix[])new Fix[]{JavaFixUtilities.rewriteFix((HintContext)ctx, (String)Bundle.FIX_expression2Return(), (TreePath)ctx.getPath(), (String)target)});
    }

    public static ErrorDescription reference2Lambda(HintContext ctx) {
        Element refered = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (refered == null || refered.getKind() != ElementKind.METHOD) {
            return null;
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_memberReference2Lambda(), (Fix[])new Fix[]{new MemberReference2Lambda(ctx.getInfo(), ctx.getPath()).toEditorFix()});
    }

    public static ErrorDescription explicitParameterTypes(HintContext ctx) {
        LambdaExpressionTree let = (LambdaExpressionTree)ctx.getPath().getLeaf();
        if (ctx.getInfo().getTreeUtilities().hasError((Tree)let, new String[0])) {
            return null;
        }
        boolean hasSyntheticParameterName = false;
        for (VariableTree variableTree : let.getParameters()) {
            hasSyntheticParameterName |= variableTree.getType() == null || ctx.getInfo().getTreeUtilities().isSynthetic(TreePath.getPath(ctx.getPath(), variableTree.getType()));
        }
        if (!hasSyntheticParameterName) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_addExplicitLambdaParameters(), (Fix[])new Fix[]{new AddExplicitLambdaParameterTypes(ctx.getInfo(), ctx.getPath()).toEditorFix()});
    }

    public static ErrorDescription implicitVarParameterTypes(HintContext ctx) {
        if (ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_9) < 2) {
            return null;
        }
        if (ctx.getInfo().getTreeUtilities().hasError(ctx.getPath().getLeaf(), new String[0])) {
            return null;
        }
        LambdaExpressionTree let = (LambdaExpressionTree)ctx.getPath().getLeaf();
        if (let.getParameters() == null || let.getParameters().isEmpty()) {
            return null;
        }
        VariableTree var = let.getParameters().get(0);
        if (ctx.getInfo().getTreeUtilities().isVarType(new TreePath(ctx.getPath(), var))) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)NbBundle.getMessage(Lambda.class, (String)"ERR_ConvertVarLambdaParameters"), (Fix[])new Fix[]{new AddVarLambdaParameterTypes(ctx.getInfo(), ctx.getPath()).toEditorFix()});
    }

    private static ExecutableElement findAbstractMethod(CompilationInfo info, TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return null;
        }
        TypeElement clazz = (TypeElement)((DeclaredType)type).asElement();
        if (!clazz.getKind().isInterface()) {
            return null;
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
            if (!executableElement.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            return executableElement;
        }
        for (TypeMirror typeMirror : info.getTypes().directSupertypes(type)) {
            ExecutableElement ee = Lambda.findAbstractMethod(info, typeMirror);
            if (ee == null) continue;
            return ee;
        }
        return null;
    }

    private static final class Lambda2Anonymous
    extends JavaFix {
        public Lambda2Anonymous(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_lambda2Class();
        }

        private static TypeMirror avoidIntersectionType(CompilationInfo copy, TypeMirror org) {
            if (org.getKind() == TypeKind.INTERSECTION) {
                TypeElement objEl = copy.getElements().getTypeElement("java.lang.Object");
                if (objEl == null) {
                    return org;
                }
                return objEl.asType();
            }
            return org;
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath clazz;
            ExpressionTree targetTypeTree;
            boolean bl;
            final WorkingCopy copy = ctx.getWorkingCopy();
            LambdaExpressionTree lambda = (LambdaExpressionTree)ctx.getPath().getLeaf();
            TypeMirror samType = copy.getTrees().getTypeMirror(ctx.getPath());
            if (samType == null || samType.getKind() != TypeKind.DECLARED) {
                return;
            }
            ExecutableType descriptorType = copy.getTypeUtilities().getDescriptorType((DeclaredType)samType);
            ExecutableElement abstractMethod = Lambda.findAbstractMethod((CompilationInfo)copy, samType);
            final TypeElement samTypeElement = (TypeElement)((DeclaredType)samType).asElement();
            ArrayList<VariableTree> methodParams = new ArrayList<VariableTree>();
            Iterator<? extends TypeMirror> resolvedParamTypes = descriptorType.getParameterTypes().iterator();
            Iterator<? extends VariableTree> actualParams = lambda.getParameters().iterator();
            final TreeMaker make = copy.getTreeMaker();
            while (resolvedParamTypes.hasNext() && actualParams.hasNext()) {
                VariableTree p = actualParams.next();
                TypeMirror resolvedType = resolvedParamTypes.next();
                if (p.getType() == null || copy.getTreeUtilities().isSynthetic(new TreePath(ctx.getPath(), p.getType()))) {
                    methodParams.add(make.Variable(p.getModifiers(), (CharSequence)p.getName(), make.Type(SourceUtils.resolveCapturedType((CompilationInfo)copy, (TypeMirror)resolvedType)), null));
                    continue;
                }
                methodParams.add(p);
            }
            BlockTree newMethodBody = switch (lambda.getBodyKind()) {
                case LambdaExpressionTree.BodyKind.STATEMENT -> (BlockTree)lambda.getBody();
                case LambdaExpressionTree.BodyKind.EXPRESSION -> {
                    StatementTree mainStatement = descriptorType.getReturnType() == null || descriptorType.getReturnType().getKind() != TypeKind.VOID ? make.Return((ExpressionTree)lambda.getBody()) : make.ExpressionStatement((ExpressionTree)lambda.getBody());
                    yield make.Block(Collections.singletonList(mainStatement), false);
                }
                default -> throw new IllegalStateException();
            };
            ArrayList<ExpressionTree> thrownTypes = new ArrayList<ExpressionTree>(abstractMethod.getThrownTypes().size());
            for (TypeMirror typeMirror : abstractMethod.getThrownTypes()) {
                thrownTypes.add((ExpressionTree)make.Type(typeMirror));
            }
            ModifiersTree mt = make.Modifiers(EnumSet.of(Modifier.PUBLIC));
            boolean bl2 = bl = copy.getElements().getTypeElement("java.lang.Override") != null;
            if (bl) {
                mt = make.addModifiersAnnotation(mt, make.Annotation((Tree)make.Identifier((CharSequence)"Override"), Collections.emptyList()));
            }
            TypeMirror retType = Lambda2Anonymous.avoidIntersectionType((CompilationInfo)copy, descriptorType.getReturnType());
            MethodTree newMethod = make.Method(mt, (CharSequence)abstractMethod.getSimpleName(), make.Type(retType), Collections.emptyList(), methodParams, thrownTypes, newMethodBody, null);
            ClassTree innerClass = make.Class(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)samTypeElement.getSimpleName(), Collections.emptyList(), null, Collections.emptyList(), Collections.singletonList(newMethod));
            if (((DeclaredType)samType).getTypeArguments().isEmpty()) {
                targetTypeTree = make.QualIdent((Element)samTypeElement);
            } else {
                ArrayList<Tree> typeArguments = new ArrayList<Tree>();
                for (TypeMirror typeMirror : ((DeclaredType)samType).getTypeArguments()) {
                    typeArguments.add(make.Type(Lambda2Anonymous.avoidIntersectionType((CompilationInfo)copy, SourceUtils.resolveCapturedType((CompilationInfo)copy, (TypeMirror)typeMirror))));
                }
                targetTypeTree = (ExpressionTree)((Object)make.ParameterizedType((Tree)make.QualIdent((Element)samTypeElement), typeArguments));
            }
            NewClassTree newClass = make.NewClass(null, Collections.emptyList(), targetTypeTree, Collections.emptyList(), innerClass);
            for (clazz = ctx.getPath(); clazz != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)clazz.getLeaf().getKind()); clazz = clazz.getParentPath()) {
            }
            if (clazz == null) {
                return;
            }
            final Element element = copy.getTrees().getElement(clazz);
            if (element == null || !element.getKind().isClass() && !element.getKind().isInterface()) {
                return;
            }
            copy.rewrite(ctx.getPath().getLeaf(), (Tree)newClass);
            final Name outterClassName = ((ClassTree)clazz.getLeaf()).getSimpleName();
            Scope s = copy.getTrees().getScope(ctx.getPath());
            final HashMap<Name, Element> types = new HashMap<Name, Element>();
            final HashMap<Name, Element> vars = new HashMap<Name, Element>();
            final HashSet<Name> methods = new HashSet<Name>();
            for (Element e : copy.getElementUtilities().getMembers(samTypeElement.asType(), null)) {
                switch (e.getKind()) {
                    case ENUM: 
                    case CLASS: 
                    case ANNOTATION_TYPE: 
                    case INTERFACE: 
                    case RECORD: {
                        types.put(e.getSimpleName(), e);
                        break;
                    }
                    case ENUM_CONSTANT: 
                    case FIELD: {
                        vars.put(e.getSimpleName(), e);
                        break;
                    }
                    case METHOD: {
                        methods.add(e.getSimpleName());
                    }
                }
            }
            types.put(samTypeElement.getSimpleName(), samTypeElement);
            new ErrorAwareTreePathScanner<Void, Boolean>(){

                public Void visitIdentifier(IdentifierTree node, Boolean p) {
                    boolean rewrite = false;
                    boolean statRef = false;
                    if (node.getName().contentEquals("this") || node.getName().contentEquals("super")) {
                        if (types.containsKey(outterClassName)) {
                            copy.rewrite((Tree)node, (Tree)make.MemberSelect(make.QualIdent(element), (CharSequence)node.getName()));
                        } else {
                            copy.rewrite((Tree)node, (Tree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)outterClassName), (CharSequence)node.getName()));
                        }
                    } else if (Boolean.TRUE != p) {
                        Element e = copy.getTrees().getElement(this.getCurrentPath());
                        Element other = null;
                        if (e != null) {
                            switch (e.getKind()) {
                                case METHOD: {
                                    if (!methods.contains(e.getSimpleName())) break;
                                    Map<? extends ExecutableElement, ? extends ExecutableElement> conflicting = Utilities.findConflictingMethods((CompilationInfo)copy, samTypeElement, true, Collections.singleton((ExecutableElement)e));
                                    rewrite = !conflicting.isEmpty();
                                    break;
                                }
                                case ENUM_CONSTANT: {
                                    statRef = true;
                                }
                                case FIELD: {
                                    other = (Element)vars.get(e.getSimpleName());
                                    rewrite = other != null;
                                    break;
                                }
                                case ENUM: 
                                case CLASS: 
                                case ANNOTATION_TYPE: 
                                case INTERFACE: 
                                case RECORD: {
                                    other = (Element)types.get(e.getSimpleName());
                                    rewrite = other != null;
                                    statRef = true;
                                }
                            }
                        }
                        if (rewrite) {
                            if ((statRef |= e.getModifiers().contains((Object)Modifier.STATIC)) && other == e) {
                                return (Void)super.visitIdentifier(node, (Object)p);
                            }
                            ExpressionTree n = types.containsKey(outterClassName) ? make.QualIdent(element) : make.Identifier((CharSequence)outterClassName);
                            if (!statRef) {
                                n = make.MemberSelect(n, (CharSequence)"this");
                            }
                            if (rewrite) {
                                copy.rewrite((Tree)node, (Tree)make.MemberSelect(n, (CharSequence)node.getName()));
                            }
                        }
                    }
                    return (Void)super.visitIdentifier(node, (Object)p);
                }
            }.scan(ctx.getPath(), null);
        }
    }

    private static final class Lambda2MemberReference
    extends JavaFix {
        public Lambda2MemberReference(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_lambda2MemberReference();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy copy = ctx.getWorkingCopy();
            TypeMirror samType = copy.getTrees().getTypeMirror(ctx.getPath());
            if (samType == null || samType.getKind() != TypeKind.DECLARED) {
                return;
            }
            LambdaExpressionTree lambda = (LambdaExpressionTree)ctx.getPath().getLeaf();
            Tree tree = lambda.getBody();
            if (tree.getKind() == Tree.Kind.BLOCK) {
                if (((BlockTree)tree).getStatements().size() != 1) return;
                if ((tree = (Tree)((BlockTree)tree).getStatements().get(0)).getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
                    tree = ((ExpressionStatementTree)tree).getExpression();
                } else {
                    if (tree.getKind() != Tree.Kind.RETURN) return;
                    tree = ((ReturnTree)tree).getExpression();
                }
            }
            Tree changed = null;
            if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
                changed = ConvertToLambdaConverter.methodInvocationToMemberReference(copy, tree, ctx.getPath(), lambda.getParameters(), false);
            } else if (tree.getKind() == Tree.Kind.NEW_CLASS) {
                changed = ConvertToLambdaConverter.newClassToConstructorReference(copy, tree, ctx.getPath(), lambda.getParameters(), false);
            }
            if (changed == null) return;
            copy.rewrite((Tree)lambda, changed);
        }
    }

    private static final class MemberReference2Lambda
    extends JavaFix {
        public MemberReference2Lambda(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_memberReference2Lambda();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath reference = ctx.getPath();
            Element refered = ctx.getWorkingCopy().getTrees().getElement(reference);
            if (refered == null || refered.getKind() != ElementKind.METHOD) {
                return;
            }
            MemberReferenceTree mrt = (MemberReferenceTree)ctx.getPath().getLeaf();
            Element on = ctx.getWorkingCopy().getTrees().getElement(new TreePath(ctx.getPath(), mrt.getQualifierExpression()));
            ExpressionTree reciever = mrt.getQualifierExpression();
            ArrayList<VariableTree> formals = new ArrayList<VariableTree>();
            ArrayList<IdentifierTree> actuals = new ArrayList<IdentifierTree>();
            Scope scope = ctx.getWorkingCopy().getTrees().getScope(reference);
            HashSet<String> usedNames = new HashSet<String>();
            TreeMaker make = ctx.getWorkingCopy().getTreeMaker();
            if (on != null && (on.getKind().isClass() || on.getKind().isInterface()) && !refered.getModifiers().contains((Object)Modifier.STATIC)) {
                Object name = Utilities.getName(on.asType());
                name = Utilities.makeNameUnique((CompilationInfo)ctx.getWorkingCopy(), scope, (String)name);
                formals.add(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)name, null, null));
                reciever = make.Identifier((CharSequence)name);
                usedNames.add((String)name);
            }
            for (VariableElement variableElement : ((ExecutableElement)refered).getParameters()) {
                String name = Utilities.makeNameUnique((CompilationInfo)ctx.getWorkingCopy(), scope, variableElement.getSimpleName().toString(), usedNames, null, null);
                formals.add(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)name, null, null));
                actuals.add(make.Identifier((CharSequence)name));
            }
            LambdaExpressionTree lambda = make.LambdaExpression(formals, (Tree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect(reciever, (CharSequence)mrt.getName()), actuals));
            ctx.getWorkingCopy().rewrite((Tree)mrt, (Tree)lambda);
        }
    }

    private static final class AddExplicitLambdaParameterTypes
    extends JavaFix {
        public AddExplicitLambdaParameterTypes(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_addExplicitLambdaParameters();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            LambdaExpressionTree let = (LambdaExpressionTree)ctx.getPath().getLeaf();
            for (VariableTree variableTree : let.getParameters()) {
                TreePath typePath = TreePath.getPath(ctx.getPath(), variableTree.getType());
                if (!ctx.getWorkingCopy().getTreeUtilities().isSynthetic(typePath)) continue;
                Tree imported = ctx.getWorkingCopy().getTreeMaker().Type(ctx.getWorkingCopy().getTrees().getTypeMirror(typePath));
                ctx.getWorkingCopy().rewrite(variableTree.getType(), imported);
            }
        }
    }

    private static final class AddVarLambdaParameterTypes
    extends JavaFix {
        public AddVarLambdaParameterTypes(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return NbBundle.getMessage(Lambda.class, (String)"FIX_ConvertVarLambdaParameters");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            if (ctx.getPath().getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
                LambdaExpressionTree let = (LambdaExpressionTree)ctx.getPath().getLeaf();
                TreeMaker make = ctx.getWorkingCopy().getTreeMaker();
                let.getParameters().forEach(var -> ctx.getWorkingCopy().rewrite(var.getType(), make.Type("var")));
            }
        }
    }
}

