/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.netbeans.api.java.queries.CompilerOptionsQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;

public class ConvertToTextBlock {
    private static final int TEXT_BLOCK_PREVIEW_JDK_VERSION = 14;

    public static ErrorDescription computeWarning(HintContext ctx) {
        if (Utilities.isJDKVersionLower(14) && !CompilerOptionsQuery.getOptions((FileObject)ctx.getInfo().getFileObject()).getArguments().contains("--enable-preview")) {
            return null;
        }
        if (ctx.getPath().getParentPath() != null && ConvertToTextBlock.getTextOrNull(ctx.getPath().getParentPath()) != null) {
            return null;
        }
        String text = ConvertToTextBlock.getTextOrNull(ctx.getPath());
        if (text == null) {
            return null;
        }
        Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath(), text).toEditorFix();
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_ConvertToTextBlock(), (Fix[])new Fix[]{fix});
    }

    private static String getTextOrNull(TreePath tp) {
        StringBuilder text = new StringBuilder();
        Tree current = tp.getLeaf();
        while (current.getKind() == Tree.Kind.PLUS) {
            BinaryTree bt = (BinaryTree)current;
            if (bt.getRightOperand().getKind() != Tree.Kind.STRING_LITERAL) {
                return null;
            }
            text.insert(0, ((LiteralTree)bt.getRightOperand()).getValue());
            current = bt.getLeftOperand();
        }
        if (current.getKind() != Tree.Kind.STRING_LITERAL) {
            return null;
        }
        text.insert(0, ((LiteralTree)current).getValue());
        String textString = text.toString();
        if (!textString.contains("\n")) {
            return null;
        }
        return textString;
    }

    private static final class FixImpl
    extends JavaFix {
        private final String text;

        public FixImpl(CompilationInfo info, TreePath tp, String text) {
            super(info, tp);
            this.text = text;
        }

        protected String getText() {
            return Bundle.FIX_ConvertToTextBlock();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            ctx.getWorkingCopy().rewrite(ctx.getPath().getLeaf(), (Tree)ctx.getWorkingCopy().getTreeMaker().Literal((Object)this.text.split("\n", -1)));
        }
    }
}

