/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.queries.CompilerOptionsQuery;
import org.netbeans.api.java.source.CodeStyleUtils;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.filesystems.FileObject;

public class ConvertToRecordPattern {
    private static final int RECORD_PATTERN_PREVIEW_JDK_VERSION = 19;

    public static ErrorDescription trivial(final HintContext ctx) {
        if (Utilities.isJDKVersionLower(19) && !CompilerOptionsQuery.getOptions((FileObject)ctx.getInfo().getFileObject()).getArguments().contains("--enable-preview")) {
            return null;
        }
        ElementKind kind = ctx.getInfo().getTrees().getElement((TreePath)ctx.getVariables().get("$typeI0")).getKind();
        if (kind == ElementKind.RECORD) {
            final HashSet<TreePath> convertPath = new HashSet<TreePath>();
            final HashSet<String> localVarList = new HashSet<String>();
            localVarList.add(ctx.getInfo().getTrees().getElement((TreePath)ctx.getVariables().get("$expr")).getSimpleName().toString());
            final HashMap<String, String> varNames = new HashMap<String, String>();
            new CancellableTreePathScanner<Void, Void>(){
                String variableName = null;

                public Void visitVariable(VariableTree node, Void p) {
                    if (this.variableName == null) {
                        this.variableName = node.getName().toString();
                    }
                    localVarList.add(node.getName().toString());
                    HashMap outerVariables = new HashMap();
                    HashMap innerVariables = new HashMap();
                    boolean match = MatcherUtilities.matches((HintContext)ctx, (TreePath)this.getCurrentPath(), (String)"$type $var1 = $expr3.$meth1()", outerVariables, new HashMap(), innerVariables);
                    if (match && ((TreePath)outerVariables.get("$expr3")).getLeaf().toString().equals(this.variableName)) {
                        varNames.put((String)innerVariables.get("$meth1"), (String)innerVariables.get("$var1"));
                        convertPath.add(this.getCurrentPath());
                    }
                    return (Void)super.visitVariable(node, (Object)p);
                }

                protected boolean isCanceled() {
                    return ctx.isCanceled();
                }
            }.scan(ctx.getPath(), null);
            TypeElement type = (TypeElement)ctx.getInfo().getTrees().getElement((TreePath)ctx.getVariables().get("$typeI0"));
            List<? extends RecordComponentElement> recordSig = type.getRecordComponents();
            if (!convertPath.isEmpty()) {
                Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath(), convertPath, recordSig, varNames, localVarList).toEditorFix();
                return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_ConvertToRecordPattern(), (Fix[])new Fix[]{fix});
            }
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        private final Set<TreePathHandle> replaceOccurrences;
        private final List<? extends ElementHandle> recordSig;
        private final Map<String, String> varNames;
        private final Set<String> localVarList;

        public FixImpl(CompilationInfo info, TreePath main, Set<TreePath> replaceOccurrences, List<? extends RecordComponentElement> recordSig, Map<String, String> varNames, Set<String> localVarList) {
            super(info, main);
            this.recordSig = recordSig.stream().map(elem -> ElementHandle.create((Element)elem)).collect(Collectors.toList());
            this.varNames = varNames;
            this.replaceOccurrences = replaceOccurrences.stream().map(tp -> TreePathHandle.create((TreePath)tp, (CompilationInfo)info)).collect(Collectors.toSet());
            this.localVarList = new HashSet<String>(localVarList);
        }

        protected String getText() {
            return Bundle.FIX_ConvertToRecordPattern();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath main = ctx.getPath();
            IfTree it = (IfTree)main.getLeaf();
            InstanceOfTree iot = (InstanceOfTree)((ParenthesizedTree)it.getCondition()).getExpression();
            BindingPatternTree pattern = (BindingPatternTree)iot.getPattern();
            StatementTree bt = it.getThenStatement();
            ArrayList<BindingPatternTree> bindTree = new ArrayList<BindingPatternTree>();
            ArrayList recordSignature = new ArrayList();
            this.recordSig.stream().map(elem -> elem.resolve((CompilationInfo)wc)).forEach(elem -> recordSignature.add((RecordComponentElement)elem));
            HashSet<String> localVars = new HashSet<String>(this.localVarList);
            for (RecordComponentElement recordComponent : recordSignature) {
                String compName = recordComponent.getSimpleName().toString();
                String name = null;
                String returnType = null;
                if (this.varNames.containsKey(compName)) {
                    name = this.varNames.get(compName);
                } else {
                    int cnt = 1;
                    name = compName;
                    while (SourceVersion.isKeyword(name) || localVars.contains(name)) {
                        name = CodeStyleUtils.addPrefixSuffix((CharSequence)(compName + cnt++), (String)"", (String)"");
                    }
                    localVars.add(name);
                }
                returnType = recordComponent.getAccessor().getReturnType().toString();
                returnType = returnType.substring(returnType.lastIndexOf(".") + 1);
                bindTree.add((BindingPatternTree)wc.getTreeMaker().BindingPattern(wc.getTreeMaker().Variable(wc.getTreeMaker().Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)name, (Tree)wc.getTreeMaker().Identifier((CharSequence)returnType), null)));
            }
            InstanceOfTree cond = wc.getTreeMaker().InstanceOf(iot.getExpression(), (Tree)wc.getTreeMaker().RecordPattern((ExpressionTree)pattern.getVariable().getType(), bindTree, pattern.getVariable()));
            List removeList = this.replaceOccurrences.stream().map(tph -> tph.resolve((CompilationInfo)wc).getLeaf()).collect(Collectors.toList());
            for (Tree t : removeList) {
                bt = wc.getTreeMaker().removeBlockStatement((BlockTree)bt, (StatementTree)t);
            }
            wc.rewrite((Tree)it, (Tree)wc.getTreeMaker().If((ExpressionTree)wc.getTreeMaker().Parenthesized((ExpressionTree)cond), bt, it.getElseStatement()));
        }
    }
}

