/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.lib.editor.util.StringEscapeUtils;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;

public class ExtendsImplements
implements ErrorRule<Void> {
    private static final String KEY_EXTENDS_TO_IMPLEMENTS = "compiler.err.no.intf.expected.here";
    private static final String KEY_IMPLEMENTS_TO_EXTENDS = "compiler.err.intf.expected.here";
    private static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.err.no.intf.expected.here", "compiler.err.intf.expected.here"));

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        if (KEY_EXTENDS_TO_IMPLEMENTS.equals(diagnosticKey)) {
            Element wrong = info.getTrees().getElement(treePath);
            TreePath clazz = ExtendsImplements.findClass(treePath);
            if (wrong == null || !wrong.getKind().isInterface() || clazz == null) {
                return null;
            }
            return Collections.singletonList(new FixImpl(info, treePath, true).toEditorFix());
        }
        if (KEY_IMPLEMENTS_TO_EXTENDS.equals(diagnosticKey)) {
            Element wrong = info.getTrees().getElement(treePath);
            TreePath clazz = ExtendsImplements.findClass(treePath);
            if (wrong == null || !wrong.getKind().isClass() || clazz == null) {
                return null;
            }
            return Collections.singletonList(new FixImpl(info, treePath, false).toEditorFix());
        }
        return null;
    }

    public String getId() {
        return ExtendsImplements.class.getName();
    }

    public String getDisplayName() {
        return Bundle.DN_ExtendsImplements();
    }

    public void cancel() {
    }

    private static TreePath findClass(TreePath treePath) {
        TreePath clazz;
        for (clazz = treePath; clazz != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)clazz.getLeaf().getKind()); clazz = clazz.getParentPath()) {
        }
        return clazz;
    }

    private static final class FixImpl
    extends JavaFix {
        private final boolean extends2Implements;
        private final String displayName;

        public FixImpl(CompilationInfo info, TreePath tp, boolean extends2Implements) {
            super(info, tp);
            this.extends2Implements = extends2Implements;
            this.displayName = StringEscapeUtils.escapeHtml((String)tp.getLeaf().toString());
        }

        protected String getText() {
            return this.extends2Implements ? Bundle.FIX_Extend2Implements(this.displayName) : Bundle.FIX_Implements2Extend(this.displayName);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath clazz = ExtendsImplements.findClass(ctx.getPath());
            if (clazz == null) {
                return;
            }
            TreeMaker make = ctx.getWorkingCopy().getTreeMaker();
            ClassTree original = (ClassTree)clazz.getLeaf();
            ClassTree nue = this.extends2Implements ? make.insertClassImplementsClause(make.setExtends(original, null), 0, ctx.getPath().getLeaf()) : make.setExtends(make.removeClassImplementsClause(original, ctx.getPath().getLeaf()), (ExpressionTree)ctx.getPath().getLeaf());
            ctx.getWorkingCopy().rewrite((Tree)original, (Tree)nue);
        }
    }
}

