/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class AddOrRemoveFinalModifier
implements ErrorRule<Void> {
    private final String id;
    private final Type type;
    private final String errorCode;
    private final String displayName;
    private final String description;
    private final String fixDescription;

    private AddOrRemoveFinalModifier(String id, String errorCode, String displayName, String description, String fixDescription, Type type) {
        this.id = id;
        this.errorCode = errorCode;
        this.displayName = displayName;
        this.description = description;
        this.fixDescription = fixDescription;
        this.type = type;
    }

    public static AddOrRemoveFinalModifier createRemoveFinalFromVariable() {
        return new AddOrRemoveFinalModifier(AddOrRemoveFinalModifier.class.getName() + ".var", "compiler.err.cant.assign.val.to.var", Bundle.DN_RemoveFinalModifierFromVariable(), Bundle.DESC_RemoveFinalModifierFromVariable(), "FIX_RemoveFinalModifierFromVariable", Type.REMOVE);
    }

    public static AddOrRemoveFinalModifier createRemoveFinalFromParameter() {
        return new AddOrRemoveFinalModifier(AddOrRemoveFinalModifier.class.getName() + ".param", "compiler.err.final.parameter.may.not.be.assigned", Bundle.DN_RemoveFinalModifierFromParameter(), Bundle.DESC_RemoveFinalModifierFromParameter(), "FIX_RemoveFinalModifierFromParameter", Type.REMOVE);
    }

    public static AddOrRemoveFinalModifier createAddFinalModifier() {
        return new AddOrRemoveFinalModifier("org.netbeans.modules.java.hints.errors.MakeVariableFinal", "compiler.err.local.var.accessed.from.icls.needs.final", Bundle.DN_MakeVariableFinal(), Bundle.DESC_MakeVariableFinal(), "FIX_MakeVariableFinal", Type.ADD);
    }

    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList(this.errorCode));
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        Tree leaf = treePath.getLeaf();
        if (leaf.getKind() == Tree.Kind.IDENTIFIER) {
            Element el = compilationInfo.getTrees().getElement(treePath);
            if (el == null) {
                return null;
            }
            TreePath declaration = compilationInfo.getTrees().getPath(el);
            if (declaration != null && declaration.getCompilationUnit() == compilationInfo.getCompilationUnit()) {
                return Collections.singletonList(new FixImpl(compilationInfo.getFileObject(), el.getSimpleName().toString(), TreePathHandle.create((TreePath)declaration, (CompilationInfo)compilationInfo), this.fixDescription, this.type).toEditorFix());
            }
        }
        return Collections.emptyList();
    }

    public void cancel() {
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    private static enum Type {
        REMOVE,
        ADD;

    }

    private static final class FixImpl
    extends JavaFix {
        private String variableName;
        private TreePathHandle variable;
        private FileObject file;
        private final String fixDescription;
        private final Type type;

        public FixImpl(FileObject file, String variableName, TreePathHandle variable, String fixDescription, Type type) {
            super(variable);
            this.file = file;
            this.variableName = variableName;
            this.variable = variable;
            this.fixDescription = fixDescription;
            this.type = type;
        }

        public String getText() {
            return NbBundle.getMessage(AddOrRemoveFinalModifier.class, (String)this.fixDescription, (Object)String.valueOf(this.variableName));
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            if (tp == null) {
                return;
            }
            VariableTree vt = (VariableTree)tp.getLeaf();
            ModifiersTree mt = vt.getModifiers();
            EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
            modifiers.addAll(mt.getFlags());
            switch (this.type) {
                case ADD: {
                    modifiers.add(Modifier.FINAL);
                    break;
                }
                case REMOVE: {
                    modifiers.remove((Object)Modifier.FINAL);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type " + this.type + " not supported");
                }
            }
            ModifiersTree newMod = wc.getTreeMaker().Modifiers(modifiers, mt.getAnnotations());
            wc.rewrite((Tree)mt, (Tree)newMod);
        }

        public int hashCode() {
            return this.variable.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FixImpl)) {
                return false;
            }
            return this.variable.equals((Object)((FixImpl)((Object)obj)).variable);
        }
    }
}

