/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;

public class ExceptionBreakpoint
extends AbstractBreakpoint {
    private static final String FONT_GRAY_COLOR = "<font color=\"#999999\">";
    private static final String CLOSE_FONT = "</font>";
    private final String exceptionName;
    @NullAllowed
    private volatile String message;
    @NullAllowed
    private volatile String code;

    public ExceptionBreakpoint(String exceptionName) {
        this.exceptionName = exceptionName;
    }

    public String getException() {
        return this.exceptionName;
    }

    public void setExceptionMessage(String message) {
        this.message = message;
    }

    @CheckForNull
    public String getExceptionMessage() {
        return this.buildText(this.message);
    }

    public void setExceptionCode(String code) {
        this.code = code;
    }

    @CheckForNull
    public String getExceptionCode() {
        return this.buildText(this.code);
    }

    @CheckForNull
    private String buildText(String text) {
        if (!StringUtils.isEmpty((String)text)) {
            StringBuilder builder = new StringBuilder().append(FONT_GRAY_COLOR).append(text).append(CLOSE_FONT);
            return builder.toString();
        }
        return null;
    }

    @Override
    public boolean isSessionRelated(DebugSession session) {
        return true;
    }
}

