/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.css.lib.TokenNode;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.css.lib.api.TreePath;

public final class NodeUtil {
    private static final char ELEMENT_PATH_ELEMENTS_DELIMITER = '/';
    private static final char ELEMENT_PATH_INDEX_DELIMITER = '|';
    private static final String INDENT = "    ";
    private static final Pattern ESCAPE = Pattern.compile("\\\\(?:(?:(?<hex>[0-9a-fA-F]{1,6})[\n\r\f\t ]?)|(?<direct>[^\n\r0-9A-Fa-f]))");

    private NodeUtil() {
    }

    public static int[] getTrimmedNodeRange(Node node) {
        int to_diff;
        int from_diff;
        CharSequence text = node.image();
        for (from_diff = 0; from_diff < text.length() && Character.isWhitespace(text.charAt(from_diff)); ++from_diff) {
        }
        for (to_diff = 0; to_diff < text.length() - from_diff && Character.isWhitespace(text.charAt(text.length() - 1 - to_diff)); ++to_diff) {
        }
        return new int[]{node.from() + from_diff, node.to() - to_diff};
    }

    public static Node findNonTokenNodeAtOffset(Node node, int offset) {
        Node found = NodeUtil.findNodeAtOffset(node, offset);
        return found instanceof TokenNode ? found.parent() : found;
    }

    public static Node findNodeAtOffset(Node node, int astOffset) {
        int so = node.from();
        int eo = node.to();
        if (astOffset < so || astOffset > eo) {
            return null;
        }
        if (astOffset >= so && astOffset <= eo && node.children().isEmpty()) {
            return node;
        }
        for (Node child : node.children()) {
            int ch_so = child.from();
            int ch_eo = child.to();
            if (astOffset < ch_so || astOffset > ch_eo) continue;
            return NodeUtil.findNodeAtOffset(child, astOffset);
        }
        return node;
    }

    public static Node getChildByType(Node node, NodeType type) {
        Node[] children = NodeUtil.getChildrenByType(node, type);
        return children.length == 0 ? null : children[0];
    }

    public static Node getChildTokenNode(Node node, CssTokenId tokenId) {
        Node[] children;
        for (Node n : children = NodeUtil.getChildrenByType(node, NodeType.token)) {
            TokenNode tn = (TokenNode)n;
            if (tn.getTokenId() != tokenId) continue;
            return n;
        }
        return null;
    }

    public static CssTokenId getTokenNodeTokenId(Node node) {
        if (node.type() != NodeType.token) {
            throw new IllegalArgumentException(String.format("The argument must by of NodeType.token type. The actual type is %s", new Object[]{node.type()}));
        }
        return ((TokenNode)node).getTokenId();
    }

    public static Node getAncestorByType(Node node, final NodeType type) {
        AtomicReference found = new AtomicReference();
        NodeVisitor<AtomicReference<Node>> visitor = new NodeVisitor<AtomicReference<Node>>(found){

            @Override
            public boolean visit(Node node) {
                if (node.type() == type) {
                    ((AtomicReference)this.getResult()).set(node);
                    return true;
                }
                return false;
            }
        };
        visitor.visitAncestors(node);
        return (Node)found.get();
    }

    public static List<Node> getChildrenRecursivelyByType(Node root, NodeType ... type) {
        final EnumSet<NodeType[]> nodeTypes = EnumSet.of(type[0], type);
        ArrayList found = new ArrayList();
        NodeVisitor<List<Node>> visitor = new NodeVisitor<List<Node>>(found){

            @Override
            public boolean visit(Node node) {
                if (nodeTypes.contains((Object)node.type())) {
                    ((List)this.getResult()).add(node);
                }
                return false;
            }
        };
        visitor.visitChildren(root);
        return (List)visitor.getResult();
    }

    public static Node[] getChildrenByType(Node node, NodeType type) {
        ArrayList<Node> list = new ArrayList<Node>(node.children().size() / 4);
        for (Node child : node.children()) {
            if (child.type() != type) continue;
            list.add(child);
        }
        return list.toArray(new Node[0]);
    }

    public static Node getSibling(Node node, boolean before) {
        Node parent = node.parent();
        if (parent == null) {
            return null;
        }
        Node sibling = null;
        for (int i = 0; i < parent.children().size(); ++i) {
            List<Node> children = parent.children();
            Node child = children.get(i);
            if (child != node) continue;
            if (before) {
                if (i == 0) {
                    return null;
                }
                return children.get(i - 1);
            }
            if (i == children.size() - 1) {
                return null;
            }
            return children.get(i + 1);
        }
        return sibling;
    }

    public static String getElementId(Node node) {
        TreePath tp = new TreePath(node);
        return NodeUtil.encodeToString(tp);
    }

    public static String encodeToString(TreePath treePath) {
        StringBuilder sb = new StringBuilder();
        List<Node> p = treePath.path();
        for (int i = p.size() - 2; i >= 0; --i) {
            Node node = p.get(i);
            Node parent = node.parent();
            int myIndex = parent == null ? 0 : NodeUtil.getIndexInSimilarNodes(node.parent(), node);
            sb.append(node.name());
            if (myIndex > 0) {
                sb.append('|');
                sb.append(myIndex);
            }
            if (i <= 0) continue;
            sb.append('/');
        }
        return sb.toString();
    }

    private static int getIndexInSimilarNodes(Node parent, Node node) {
        int index = -1;
        for (Node child : parent.children()) {
            if (node.name().equals(child.name()) && node.type() == child.type()) {
                ++index;
            }
            if (child != node) continue;
            break;
        }
        return index;
    }

    public static Node query(Node base, String path) {
        return NodeUtil.query(base, path, false);
    }

    public static Node query(Node base, String path, boolean caseInsensitive) {
        StringTokenizer st = new StringTokenizer(path, "/");
        Node found = base;
        while (st.hasMoreTokens()) {
            String nodeName;
            String token = st.nextToken();
            int indexDelim = token.indexOf(124);
            String string = nodeName = indexDelim >= 0 ? token.substring(0, indexDelim) : token;
            if (caseInsensitive) {
                nodeName = nodeName.toLowerCase(Locale.ENGLISH);
            }
            String sindex = indexDelim >= 0 ? token.substring(indexDelim + 1) : "0";
            int index = Integer.parseInt(sindex);
            int count = 0;
            Node foundLocal = null;
            for (Node child : found.children()) {
                String childName = child.name();
                if (!(caseInsensitive ? (childName = childName.toLowerCase(Locale.ENGLISH)) : childName).equals(nodeName) || count++ != index) continue;
                foundLocal = child;
                break;
            }
            if (foundLocal != null) {
                found = foundLocal;
                if (st.hasMoreTokens()) continue;
                assert (found.name().equals(nodeName));
                return found;
            }
            return null;
        }
        return null;
    }

    public static void dumpTree(Node node) {
        PrintWriter pw = new PrintWriter(System.out);
        NodeUtil.dumpTree(node, pw);
        pw.flush();
    }

    public static void dumpTree(Node node, PrintWriter pw) {
        NodeUtil.dump(node, 0, pw);
    }

    private static void dump(Node tree, int level, PrintWriter pw) {
        for (int i = 0; i < level; ++i) {
            pw.print(INDENT);
        }
        pw.print(tree.toString());
        pw.println();
        for (Node c : tree.children()) {
            NodeUtil.dump(c, level + 1, pw);
        }
    }

    public static boolean isSelectorNode(Node node) {
        switch (node.type()) {
            case elementName: 
            case cssClass: 
            case cssId: {
                return true;
            }
        }
        return false;
    }

    public static int[] getRuleBodyRange(Node node) {
        if (node.type() != NodeType.rule) {
            throw new IllegalArgumentException("Only selector node is allowed as a parameter!");
        }
        Node lbrace = NodeUtil.getChildTokenNode(node, CssTokenId.LBRACE);
        Node rbrace = NodeUtil.getChildTokenNode(node, CssTokenId.RBRACE);
        if (lbrace == null || rbrace == null) {
            return null;
        }
        return new int[]{lbrace.from(), rbrace.to()};
    }

    public static boolean isOfType(Node node, NodeType ... types) {
        for (NodeType type : types) {
            if (node.type() != type) continue;
            return true;
        }
        return false;
    }

    public static boolean containsError(Node node) {
        AtomicBoolean error = new AtomicBoolean(false);
        NodeVisitor<AtomicBoolean> visitor = new NodeVisitor<AtomicBoolean>(error){

            @Override
            public boolean visit(Node node) {
                if (node.type() == NodeType.error) {
                    ((AtomicBoolean)this.getResult()).set(true);
                    return true;
                }
                return false;
            }
        };
        visitor.visitChildren(node);
        return ((AtomicBoolean)visitor.getResult()).get();
    }

    public static String unescape(CharSequence image) {
        if (image == null) {
            return null;
        }
        Matcher m = ESCAPE.matcher(image);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            if (m.group("hex") != null) {
                String hexString = m.group(1);
                try {
                    int codePoint = Integer.parseInt(hexString, 16);
                    if (Character.isBmpCodePoint(codePoint)) {
                        m.appendReplacement(sb, "");
                        sb.append((char)codePoint);
                        continue;
                    }
                    if (Character.isValidCodePoint(codePoint)) {
                        m.appendReplacement(sb, "");
                        sb.append(Character.highSurrogate(codePoint));
                        sb.append(Character.lowSurrogate(codePoint));
                        continue;
                    }
                    m.appendReplacement(sb, m.group());
                    continue;
                }
                catch (NumberFormatException ex) {
                    return m.group();
                }
            }
            m.appendReplacement(sb, Matcher.quoteReplacement(m.group("direct")));
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

