/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.circuitbreaker;

import com.oracle.bmc.circuitbreaker.CallNotAllowedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;

public interface OciCircuitBreaker {
    public CircuitBreaker getR4jCircuitBreaker();

    public String getName();

    public CircuitBreaker.State getState();

    public boolean tryAcquirePermission();

    public void releasePermission();

    public void acquirePermission();

    public long getCurrentTimestamp();

    public TimeUnit getTimestampUnit();

    public void onError(long var1, TimeUnit var3, Throwable var4);

    public void onSuccess(long var1, TimeUnit var3);

    public void onResult(long var1, TimeUnit var3, Object var4);

    public Config getCircuitBreakerConfig();

    public CallNotAllowedException createCallNotAllowedException();

    public String circuitBreakerCallNotPermittedErrorMessage(String var1);

    public void addToHistory(Throwable var1, Integer var2, Map<String, String> var3);

    public List<ErrorHistoryItem> getHistory();

    public String getHistoryAsString();

    public static class ErrorHistoryItem {
        private final Throwable throwable;
        private final Integer status;
        private final Map<String, String> messages;

        public ErrorHistoryItem(Throwable throwable, Integer status, Map<String, String> messages) {
            this.throwable = throwable;
            this.messages = messages;
            this.status = status;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public Map<String, String> getMessages() {
            return this.messages;
        }

        public int getStatus() {
            return this.status;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> e : this.messages.entrySet()) {
                sb.append(e.getKey()).append(": ").append(e.getValue()).append("; ");
            }
            sb.append("status: ").append(this.status);
            return sb.toString();
        }
    }

    public static interface Config {
        public boolean isWritableStackTraceEnabled();

        public float getFailureRateThreshold();

        public int getSlidingWindowSize();

        public Predicate<Throwable> getRecordExceptionPredicate();

        public int getMinimumNumberOfCalls();

        public int getPermittedNumberOfCallsInHalfOpenState();

        public SlidingWindowType getSlidingWindowType();

        public float getSlowCallRateThreshold();

        public Duration getSlowCallDurationThreshold();

        @FunctionalInterface
        public static interface IntervalFunction
        extends Function<Integer, Long> {
        }

        public static enum SlidingWindowType {
            TIME_BASED,
            COUNT_BASED;

        }
    }
}

