/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import org.netbeans.modules.properties.PresentableFileEntry;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public class FileEntryNode
extends AbstractNode {
    static final long serialVersionUID = -7882925922830244768L;
    private PresentableFileEntry entry;

    public FileEntryNode(PresentableFileEntry entry, Children ch) {
        super(ch);
        this.entry = entry;
        PropL propListener = new PropL();
        entry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)propListener, (Object)((Object)entry)));
        entry.getDataObject().addPropertyChangeListener((PropertyChangeListener)propListener);
        super.setName(entry.getName());
    }

    private String getBundleString(String s) {
        return NbBundle.getMessage(FileEntryNode.class, (String)s);
    }

    public <T extends Node.Cookie> T getCookie(Class<T> cl) {
        T c = this.entry.getCookie(cl);
        if (c != null) {
            return c;
        }
        return (T)super.getCookie(cl);
    }

    public PresentableFileEntry getFileEntry() {
        return this.entry;
    }

    public boolean canDestroy() {
        return this.entry.isDeleteAllowed();
    }

    public void destroy() throws IOException {
        this.entry.delete();
        super.destroy();
    }

    public final boolean canCopy() {
        return this.entry.isCopyAllowed();
    }

    public final boolean canCut() {
        return this.entry.isMoveAllowed();
    }

    public void setName(String name) {
        try {
            this.entry.renameEntry(name);
            super.setName(name);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    @Deprecated
    public SystemAction getDefaultAction() {
        if (this.entry.isTemplate()) {
            return null;
        }
        Action a = this.getPreferredAction();
        if (a instanceof SystemAction) {
            return (SystemAction)a;
        }
        return null;
    }

    public Action getPreferredAction() {
        if (this.entry.isTemplate()) {
            return null;
        }
        return super.getPreferredAction();
    }

    protected Sheet createSheet() {
        Sheet s = Sheet.createDefault();
        Sheet.Set ss = s.get("properties");
        PropertySupport.ReadWrite<String> p = new PropertySupport.ReadWrite<String>("name", String.class, this.getBundleString("PROP_name"), this.getBundleString("HINT_name")){

            public String getValue() {
                return FileEntryNode.this.entry.getName();
            }

            public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                FileEntryNode.this.setName(val);
            }

            public boolean canWrite() {
                return FileEntryNode.this.entry.isRenameAllowed();
            }
        };
        p.setName("name");
        ss.put((Node.Property)p);
        try {
            p = new PropertySupport.Reflection((Object)this.entry, Boolean.TYPE, "isTemplate", "setTemplate");
            p.setName("template");
            p.setDisplayName(this.getBundleString("PROP_template"));
            p.setShortDescription(this.getBundleString("HINT_template"));
            ss.put((Node.Property)p);
        }
        catch (Exception ex) {
            throw new IllegalStateException();
        }
        return s;
    }

    void fireChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        if (propertyName.equals("cookie")) {
            this.fireCookieChange();
            return;
        }
        if (this.hasProperty(propertyName)) {
            this.firePropertyChange(propertyName, ev.getOldValue(), ev.getNewValue());
        }
        if (propertyName.equals("name")) {
            super.setName(this.entry.getName());
        }
    }

    private boolean hasProperty(String name) {
        Node.PropertySet[] npsets = this.getPropertySets();
        for (int i = 0; i < npsets.length; ++i) {
            Node.PropertySet npset = npsets[i];
            Node.Property[] nps = npset.getProperties();
            for (int j = 0; j < nps.length; ++j) {
                Node.Property np = nps[j];
                if (!name.equals(np.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private class PropL
    implements PropertyChangeListener {
        private PropL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            FileEntryNode.this.fireChange(ev);
        }
    }
}

