/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.requests.HasContentLength;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.Objects;

public class UploadPartRequest
extends BmcRequest<InputStream>
implements HasContentLength {
    private String namespaceName;
    private String bucketName;
    private String objectName;
    private String uploadId;
    private Integer uploadPartNum;
    private Long contentLength;
    private InputStream uploadPartBody;
    private String opcClientRequestId;
    private String ifMatch;
    private String ifNoneMatch;
    private String expect;
    private String contentMD5;
    private String opcSseCustomerAlgorithm;
    private String opcSseCustomerKey;
    private String opcSseCustomerKeySha256;
    private String opcSseKmsKeyId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public Integer getUploadPartNum() {
        return this.uploadPartNum;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public InputStream getUploadPartBody() {
        return this.uploadPartBody;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getExpect() {
        return this.expect;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public String getOpcSseCustomerAlgorithm() {
        return this.opcSseCustomerAlgorithm;
    }

    public String getOpcSseCustomerKey() {
        return this.opcSseCustomerKey;
    }

    public String getOpcSseCustomerKeySha256() {
        return this.opcSseCustomerKeySha256;
    }

    public String getOpcSseKmsKeyId() {
        return this.opcSseKmsKeyId;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.uploadPartBody;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).bucketName(this.bucketName).objectName(this.objectName).uploadId(this.uploadId).uploadPartNum(this.uploadPartNum).contentLength(this.contentLength).uploadPartBody(this.uploadPartBody).opcClientRequestId(this.opcClientRequestId).ifMatch(this.ifMatch).ifNoneMatch(this.ifNoneMatch).expect(this.expect).contentMD5(this.contentMD5).opcSseCustomerAlgorithm(this.opcSseCustomerAlgorithm).opcSseCustomerKey(this.opcSseCustomerKey).opcSseCustomerKeySha256(this.opcSseCustomerKeySha256).opcSseKmsKeyId(this.opcSseKmsKeyId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",bucketName=").append(String.valueOf(this.bucketName));
        sb.append(",objectName=").append(String.valueOf(this.objectName));
        sb.append(",uploadId=").append(String.valueOf(this.uploadId));
        sb.append(",uploadPartNum=").append(String.valueOf(this.uploadPartNum));
        sb.append(",contentLength=").append(String.valueOf(this.contentLength));
        sb.append(",uploadPartBody=").append(String.valueOf(this.uploadPartBody));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",ifNoneMatch=").append(String.valueOf(this.ifNoneMatch));
        sb.append(",expect=").append(String.valueOf(this.expect));
        sb.append(",contentMD5=").append(String.valueOf(this.contentMD5));
        sb.append(",opcSseCustomerAlgorithm=").append(String.valueOf(this.opcSseCustomerAlgorithm));
        sb.append(",opcSseCustomerKey=").append(String.valueOf(this.opcSseCustomerKey));
        sb.append(",opcSseCustomerKeySha256=").append(String.valueOf(this.opcSseCustomerKeySha256));
        sb.append(",opcSseKmsKeyId=").append(String.valueOf(this.opcSseKmsKeyId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadPartRequest)) {
            return false;
        }
        UploadPartRequest other = (UploadPartRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.uploadId, other.uploadId) && Objects.equals(this.uploadPartNum, other.uploadPartNum) && Objects.equals(this.contentLength, other.contentLength) && Objects.equals(this.uploadPartBody, other.uploadPartBody) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch) && Objects.equals(this.expect, other.expect) && Objects.equals(this.contentMD5, other.contentMD5) && Objects.equals(this.opcSseCustomerAlgorithm, other.opcSseCustomerAlgorithm) && Objects.equals(this.opcSseCustomerKey, other.opcSseCustomerKey) && Objects.equals(this.opcSseCustomerKeySha256, other.opcSseCustomerKeySha256) && Objects.equals(this.opcSseKmsKeyId, other.opcSseKmsKeyId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.uploadId == null ? 43 : this.uploadId.hashCode());
        result = result * 59 + (this.uploadPartNum == null ? 43 : this.uploadPartNum.hashCode());
        result = result * 59 + (this.contentLength == null ? 43 : this.contentLength.hashCode());
        result = result * 59 + (this.uploadPartBody == null ? 43 : this.uploadPartBody.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.ifNoneMatch == null ? 43 : this.ifNoneMatch.hashCode());
        result = result * 59 + (this.expect == null ? 43 : this.expect.hashCode());
        result = result * 59 + (this.contentMD5 == null ? 43 : this.contentMD5.hashCode());
        result = result * 59 + (this.opcSseCustomerAlgorithm == null ? 43 : this.opcSseCustomerAlgorithm.hashCode());
        result = result * 59 + (this.opcSseCustomerKey == null ? 43 : this.opcSseCustomerKey.hashCode());
        result = result * 59 + (this.opcSseCustomerKeySha256 == null ? 43 : this.opcSseCustomerKeySha256.hashCode());
        result = result * 59 + (this.opcSseKmsKeyId == null ? 43 : this.opcSseKmsKeyId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UploadPartRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String bucketName = null;
        private String objectName = null;
        private String uploadId = null;
        private Integer uploadPartNum = null;
        private Long contentLength = null;
        private InputStream uploadPartBody = null;
        private String opcClientRequestId = null;
        private String ifMatch = null;
        private String ifNoneMatch = null;
        private String expect = null;
        private String contentMD5 = null;
        private String opcSseCustomerAlgorithm = null;
        private String opcSseCustomerKey = null;
        private String opcSseCustomerKeySha256 = null;
        private String opcSseKmsKeyId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public Builder uploadPartNum(Integer uploadPartNum) {
            this.uploadPartNum = uploadPartNum;
            return this;
        }

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder uploadPartBody(InputStream uploadPartBody) {
            this.uploadPartBody = uploadPartBody;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder expect(String expect) {
            this.expect = expect;
            return this;
        }

        public Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public Builder opcSseCustomerAlgorithm(String opcSseCustomerAlgorithm) {
            this.opcSseCustomerAlgorithm = opcSseCustomerAlgorithm;
            return this;
        }

        public Builder opcSseCustomerKey(String opcSseCustomerKey) {
            this.opcSseCustomerKey = opcSseCustomerKey;
            return this;
        }

        public Builder opcSseCustomerKeySha256(String opcSseCustomerKeySha256) {
            this.opcSseCustomerKeySha256 = opcSseCustomerKeySha256;
            return this;
        }

        public Builder opcSseKmsKeyId(String opcSseKmsKeyId) {
            this.opcSseKmsKeyId = opcSseKmsKeyId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UploadPartRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.objectName(o.getObjectName());
            this.uploadId(o.getUploadId());
            this.uploadPartNum(o.getUploadPartNum());
            this.contentLength(o.getContentLength());
            this.uploadPartBody(o.getUploadPartBody());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.ifMatch(o.getIfMatch());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.expect(o.getExpect());
            this.contentMD5(o.getContentMD5());
            this.opcSseCustomerAlgorithm(o.getOpcSseCustomerAlgorithm());
            this.opcSseCustomerKey(o.getOpcSseCustomerKey());
            this.opcSseCustomerKeySha256(o.getOpcSseCustomerKeySha256());
            this.opcSseKmsKeyId(o.getOpcSseKmsKeyId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UploadPartRequest build() {
            UploadPartRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.uploadPartBody(body);
            return this;
        }

        public UploadPartRequest buildWithoutInvocationCallback() {
            UploadPartRequest request = new UploadPartRequest();
            request.namespaceName = this.namespaceName;
            request.bucketName = this.bucketName;
            request.objectName = this.objectName;
            request.uploadId = this.uploadId;
            request.uploadPartNum = this.uploadPartNum;
            request.contentLength = this.contentLength;
            request.uploadPartBody = this.uploadPartBody;
            request.opcClientRequestId = this.opcClientRequestId;
            request.ifMatch = this.ifMatch;
            request.ifNoneMatch = this.ifNoneMatch;
            request.expect = this.expect;
            request.contentMD5 = this.contentMD5;
            request.opcSseCustomerAlgorithm = this.opcSseCustomerAlgorithm;
            request.opcSseCustomerKey = this.opcSseCustomerKey;
            request.opcSseCustomerKeySha256 = this.opcSseCustomerKeySha256;
            request.opcSseKmsKeyId = this.opcSseKmsKeyId;
            return request;
        }
    }
}

