/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.objectstorage.model.Bucket;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateBucketDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="metadata")
    private final Map<String, String> metadata;
    @JsonProperty(value="publicAccessType")
    private final PublicAccessType publicAccessType;
    @JsonProperty(value="objectEventsEnabled")
    private final Boolean objectEventsEnabled;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="versioning")
    private final Versioning versioning;
    @JsonProperty(value="autoTiering")
    private final Bucket.AutoTiering autoTiering;

    @Deprecated
    @ConstructorProperties(value={"namespace", "compartmentId", "name", "metadata", "publicAccessType", "objectEventsEnabled", "freeformTags", "definedTags", "kmsKeyId", "versioning", "autoTiering"})
    public UpdateBucketDetails(String namespace, String compartmentId, String name, Map<String, String> metadata, PublicAccessType publicAccessType, Boolean objectEventsEnabled, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String kmsKeyId, Versioning versioning, Bucket.AutoTiering autoTiering) {
        this.namespace = namespace;
        this.compartmentId = compartmentId;
        this.name = name;
        this.metadata = metadata;
        this.publicAccessType = publicAccessType;
        this.objectEventsEnabled = objectEventsEnabled;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.kmsKeyId = kmsKeyId;
        this.versioning = versioning;
        this.autoTiering = autoTiering;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public PublicAccessType getPublicAccessType() {
        return this.publicAccessType;
    }

    public Boolean getObjectEventsEnabled() {
        return this.objectEventsEnabled;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public Versioning getVersioning() {
        return this.versioning;
    }

    public Bucket.AutoTiering getAutoTiering() {
        return this.autoTiering;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateBucketDetails(");
        sb.append("super=").append(super.toString());
        sb.append("namespace=").append(String.valueOf(this.namespace));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", metadata=").append(String.valueOf(this.metadata));
        sb.append(", publicAccessType=").append(String.valueOf((Object)this.publicAccessType));
        sb.append(", objectEventsEnabled=").append(String.valueOf(this.objectEventsEnabled));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", versioning=").append(String.valueOf((Object)this.versioning));
        sb.append(", autoTiering=").append(String.valueOf((Object)this.autoTiering));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateBucketDetails)) {
            return false;
        }
        UpdateBucketDetails other = (UpdateBucketDetails)((Object)o);
        return Objects.equals(this.namespace, other.namespace) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.name, other.name) && Objects.equals(this.metadata, other.metadata) && Objects.equals((Object)this.publicAccessType, (Object)other.publicAccessType) && Objects.equals(this.objectEventsEnabled, other.objectEventsEnabled) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals((Object)this.versioning, (Object)other.versioning) && Objects.equals((Object)this.autoTiering, (Object)other.autoTiering) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.publicAccessType == null ? 43 : this.publicAccessType.hashCode());
        result = result * 59 + (this.objectEventsEnabled == null ? 43 : this.objectEventsEnabled.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.versioning == null ? 43 : this.versioning.hashCode());
        result = result * 59 + (this.autoTiering == null ? 43 : this.autoTiering.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Versioning implements BmcEnum
    {
        Enabled("Enabled"),
        Suspended("Suspended");

        private final String value;
        private static Map<String, Versioning> map;

        private Versioning(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Versioning create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Versioning: " + key);
        }

        static {
            map = new HashMap<String, Versioning>();
            for (Versioning v : Versioning.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PublicAccessType implements BmcEnum
    {
        NoPublicAccess("NoPublicAccess"),
        ObjectRead("ObjectRead"),
        ObjectReadWithoutList("ObjectReadWithoutList");

        private final String value;
        private static Map<String, PublicAccessType> map;

        private PublicAccessType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PublicAccessType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PublicAccessType: " + key);
        }

        static {
            map = new HashMap<String, PublicAccessType>();
            for (PublicAccessType v : PublicAccessType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="metadata")
        private Map<String, String> metadata;
        @JsonProperty(value="publicAccessType")
        private PublicAccessType publicAccessType;
        @JsonProperty(value="objectEventsEnabled")
        private Boolean objectEventsEnabled;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="versioning")
        private Versioning versioning;
        @JsonProperty(value="autoTiering")
        private Bucket.AutoTiering autoTiering;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder publicAccessType(PublicAccessType publicAccessType) {
            this.publicAccessType = publicAccessType;
            this.__explicitlySet__.add("publicAccessType");
            return this;
        }

        public Builder objectEventsEnabled(Boolean objectEventsEnabled) {
            this.objectEventsEnabled = objectEventsEnabled;
            this.__explicitlySet__.add("objectEventsEnabled");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder versioning(Versioning versioning) {
            this.versioning = versioning;
            this.__explicitlySet__.add("versioning");
            return this;
        }

        public Builder autoTiering(Bucket.AutoTiering autoTiering) {
            this.autoTiering = autoTiering;
            this.__explicitlySet__.add("autoTiering");
            return this;
        }

        public UpdateBucketDetails build() {
            UpdateBucketDetails model = new UpdateBucketDetails(this.namespace, this.compartmentId, this.name, this.metadata, this.publicAccessType, this.objectEventsEnabled, this.freeformTags, this.definedTags, this.kmsKeyId, this.versioning, this.autoTiering);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateBucketDetails model) {
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("publicAccessType")) {
                this.publicAccessType(model.getPublicAccessType());
            }
            if (model.wasPropertyExplicitlySet("objectEventsEnabled")) {
                this.objectEventsEnabled(model.getObjectEventsEnabled());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("versioning")) {
                this.versioning(model.getVersioning());
            }
            if (model.wasPropertyExplicitlySet("autoTiering")) {
                this.autoTiering(model.getAutoTiering());
            }
            return this;
        }
    }
}

