/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrarySupport;
import org.netbeans.modules.web.jsf.editor.facelets.LibraryDescriptorException;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryComponent;
import org.netbeans.modules.web.jsfapi.api.LibraryInfo;
import org.netbeans.modules.web.jsfapi.api.LibraryType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public class DefaultFaceletLibraries {
    private static DefaultFaceletLibraries INSTANCE;
    private File jsfImplJar;
    private Collection<FileObject> libraryDescriptorsFiles;
    private Map<String, FaceletsLibraryDescriptor> librariesDescriptors;
    private static Map<String, Library> jsf22FaceletPseudoLibraries;

    public static synchronized DefaultFaceletLibraries getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultFaceletLibraries();
        }
        return INSTANCE;
    }

    public DefaultFaceletLibraries(File jsfImplJar) {
        this.jsfImplJar = jsfImplJar;
        this.init(jsfImplJar);
    }

    public DefaultFaceletLibraries() {
        this(InstalledFileLocator.getDefault().locate("modules/ext/jsf-2_2/javax.faces.jar", "org.netbeans.modules.web.jsf20", false));
    }

    private void init(File jsfImplJar) {
        assert (jsfImplJar != null);
        FileObject jsfImplJarFo = FileUtil.getArchiveRoot((FileObject)FileUtil.toFileObject((File)jsfImplJar));
        this.libraryDescriptorsFiles = DefaultFaceletLibraries.findLibraryDescriptors(jsfImplJarFo, ".taglib.xml");
    }

    public File getJsfImplJar() {
        return this.jsfImplJar;
    }

    public Collection<FileObject> getLibrariesDescriptorsFiles() {
        return this.libraryDescriptorsFiles;
    }

    public synchronized Map<String, FaceletsLibraryDescriptor> getLibrariesDescriptors() {
        if (this.librariesDescriptors == null) {
            this.librariesDescriptors = new HashMap<String, FaceletsLibraryDescriptor>();
            this.parseLibraries();
        }
        return this.librariesDescriptors;
    }

    private void parseLibraries() {
        for (FileObject lfo : this.getLibrariesDescriptorsFiles()) {
            try {
                FaceletsLibraryDescriptor descritor = FaceletsLibraryDescriptor.create(lfo);
                this.librariesDescriptors.put(descritor.getNamespace(), descritor);
            }
            catch (LibraryDescriptorException ex) {
                Logger.global.log(Level.WARNING, "Error parsing facelets library " + FileUtil.getFileDisplayName((FileObject)lfo) + " in javax.faces.jar from bundled web.jsf20 library", ex);
            }
        }
    }

    public static String getLibraryDisplayName(String uri) {
        LibraryInfo li = DefaultLibraryInfo.forNamespace((String)uri);
        return li != null ? li.getDisplayName() : null;
    }

    public static String getLibraryDefaultPrefix(String uri) {
        LibraryInfo li = DefaultLibraryInfo.forNamespace((String)uri);
        return li != null ? li.getDefaultPrefix() : null;
    }

    private static Collection<FileObject> findLibraryDescriptors(FileObject classpathRoot, String suffix) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        Enumeration fos = classpathRoot.getChildren(true);
        while (fos.hasMoreElements()) {
            FileObject file = (FileObject)fos.nextElement();
            if (!file.isValid() || !file.isData() || !file.getNameExt().toLowerCase(Locale.US).endsWith(suffix)) continue;
            files.add(file);
        }
        return files;
    }

    protected static synchronized Map<String, Library> getJsf22FaceletPseudoLibraries(FaceletsLibrarySupport support) {
        if (jsf22FaceletPseudoLibraries == null) {
            HashMap map = new HashMap(2);
            DefaultLibraryInfo.JSF.getValidNamespaces().stream().filter(namespace -> namespace.startsWith("http://xmlns.jcp.org")).forEach(namespace -> map.put(namespace, new JsfFaceletPseudoLibrary(support, DefaultLibraryInfo.JSF)));
            DefaultLibraryInfo.PASSTHROUGH.getValidNamespaces().stream().filter(namespace -> namespace.startsWith("http://xmlns.jcp.org")).forEach(namespace -> map.put(namespace, new JsfFaceletPseudoLibrary(support, DefaultLibraryInfo.PASSTHROUGH)));
            jsf22FaceletPseudoLibraries = Collections.unmodifiableMap(map);
        }
        return jsf22FaceletPseudoLibraries;
    }

    private static class JsfFaceletPseudoLibrary
    implements Library {
        private final Set<String> validNamespaces;
        private final String prefix;
        private final String displayName;

        public JsfFaceletPseudoLibrary(FaceletsLibrarySupport support, DefaultLibraryInfo defaultLibraryInfo) {
            this.validNamespaces = defaultLibraryInfo.getValidNamespaces();
            this.prefix = defaultLibraryInfo.getDefaultPrefix();
            this.displayName = defaultLibraryInfo.getDisplayName();
        }

        public String getDefaultPrefix() {
            return this.prefix;
        }

        public String getDefaultNamespace() {
            return null;
        }

        public LibraryType getType() {
            return LibraryType.CLASS;
        }

        public String getNamespace() {
            return this.validNamespaces.iterator().next();
        }

        public Collection<? extends LibraryComponent> getComponents() {
            return Collections.emptyList();
        }

        public LibraryComponent getComponent(String componentName) {
            return null;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Set<String> getValidNamespaces() {
            return this.validNamespaces;
        }
    }
}

