/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.coverage;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.phpunit.commands.PhpUnit;
import org.netbeans.modules.php.phpunit.coverage.CoverageImpl;
import org.netbeans.modules.php.phpunit.coverage.PhpUnitCoverageLogParser;
import org.netbeans.modules.php.spi.testing.coverage.Coverage;

public class CoverageProvider {
    private static final Logger LOGGER = Logger.getLogger(CoverageProvider.class.getName());

    public boolean loggerFileExists() {
        return PhpUnit.COVERAGE_LOG.isFile();
    }

    @CheckForNull
    public Coverage getCoverage() {
        CoverageImpl coverage = new CoverageImpl();
        try {
            PhpUnitCoverageLogParser.parse(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(PhpUnit.COVERAGE_LOG), StandardCharsets.UTF_8)), coverage);
        }
        catch (FileNotFoundException ex) {
            assert (false);
            LOGGER.info(String.format("File %s not found. If there are no errors in PHPUnit output (verify in Output window), please report an issue (http://www.netbeans.org/issues/).", PhpUnit.COVERAGE_LOG));
            return null;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
        return coverage;
    }
}

