/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.devops;

import com.oracle.bmc.devops.DevopsClient;
import com.oracle.bmc.devops.model.ProjectSummary;
import com.oracle.bmc.devops.requests.ListProjectsRequest;
import com.oracle.bmc.devops.responses.ListProjectsResponse;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.devops.DevopsProjectItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;

public class DevopsProjectNode
extends OCINode {
    private static final String DB_ICON = "org/netbeans/modules/cloud/oracle/resources/devops_project.svg";

    public DevopsProjectNode(OCIItem item) {
        super(item);
        this.setName(item.getName());
        this.setDisplayName(item.getName());
        this.setIconBaseWithExtension(DB_ICON);
        this.setShortDescription(item.getDescription());
    }

    public static NodeProvider<OCIItem> createNode() {
        return DevopsProjectNode::new;
    }

    public static ChildrenProvider.SessionAware<CompartmentItem, DevopsProjectItem> listDevopsProjects() {
        return (compartmentId, session) -> {
            try (DevopsClient client = session.newClient(DevopsClient.class);){
                ListProjectsRequest request = ListProjectsRequest.builder().compartmentId(compartmentId.getKey().getValue()).build();
                ListProjectsResponse response = client.listProjects(request);
                List projects = response.getProjectCollection().getItems();
                for (ProjectSummary project : projects) {
                    project.getNotificationConfig().getTopicId();
                }
                String tenancyId = session.getTenancy().isPresent() ? session.getTenancy().get().getKey().getValue() : null;
                String regionCode = session.getRegion().getRegionCode();
                List list = projects.stream().map(p -> new DevopsProjectItem(OCID.of(p.getId(), "DevopsProject"), compartmentId.getKey().getValue(), p.getName(), tenancyId, regionCode)).collect(Collectors.toList());
                return list;
            }
        };
    }
}

