/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.assets.AbstractStep;
import org.netbeans.modules.cloud.oracle.assets.Bundle;
import org.netbeans.modules.cloud.oracle.assets.KubernetesUtils;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.compute.ClusterItem;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;

public class SetClusterNamespaceAction
implements ActionListener {
    private final ClusterItem context;

    public SetClusterNamespaceAction(ClusterItem context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Steps.getDefault().executeMultistep(new NamespaceStep(this.context), Lookup.EMPTY).thenAccept(values -> this.context.setNamespace((String)values.getValueForStep(NamespaceStep.class)));
    }

    public static final class NamespaceStep
    extends AbstractStep<String> {
        private final ClusterItem cluster;
        private final List<String> namespaces = new ArrayList<String>();
        private String selectedNamespace = null;

        public NamespaceStep(ClusterItem cluster) {
            this.cluster = cluster;
        }

        @Override
        public void prepare(ProgressHandle handle, Steps.Values values) {
            KubernetesUtils.runWithClient(this.cluster, client -> {
                NonNamespaceOperation namespaceOperation = client.namespaces();
                NamespaceList namespaceList = (NamespaceList)namespaceOperation.list();
                for (Namespace ns : namespaceList.getItems()) {
                    this.namespaces.add(ns.getMetadata().getName());
                }
            });
        }

        @Override
        public NotifyDescriptor createInput() {
            ArrayList<NotifyDescriptor.QuickPick.Item> items = new ArrayList<NotifyDescriptor.QuickPick.Item>(this.namespaces.size());
            for (String namespace : this.namespaces) {
                items.add(new NotifyDescriptor.QuickPick.Item(namespace, ""));
            }
            return new NotifyDescriptor.QuickPick(Bundle.Namespace(), Bundle.Namespace(), items, false);
        }

        @Override
        public boolean onlyOneChoice() {
            return this.namespaces.size() == 1;
        }

        @Override
        public void setValue(String selected) {
            this.selectedNamespace = selected;
        }

        @Override
        public String getValue() {
            return this.selectedNamespace;
        }
    }
}

