/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.netbeans.modules.cloud.oracle.actions.ConfigMapUploader;
import org.netbeans.modules.cloud.oracle.actions.DevOpsProjectConfigMapUploader;
import org.netbeans.modules.cloud.oracle.assets.ApplicationPropertiesGenerator;
import org.netbeans.modules.cloud.oracle.assets.PropertiesGenerator;
import org.netbeans.spi.lsp.CommandProvider;

public class CreateConfigCommand
implements CommandProvider {
    private static final String COMMAND_CREATE_CONFIG = "nbls.cloud.assets.config.create.local";
    private static final String COMMAND_UPLOAD_TO_CONFIGMAP_WITHIN_DEVOPS = "nbls.cloud.assets.configmap.devops.upload";
    private static final String COMMAND_UPLOAD_TO_CONFIGMAP = "nbls.cloud.assets.configmap.upload";
    private static final Set<String> COMMANDS = new HashSet<String>(Arrays.asList("nbls.cloud.assets.config.create.local", "nbls.cloud.assets.configmap.devops.upload", "nbls.cloud.assets.configmap.upload"));

    public Set<String> getCommands() {
        return Collections.unmodifiableSet(COMMANDS);
    }

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        if (COMMAND_CREATE_CONFIG.equals(command)) {
            PropertiesGenerator propGen = new PropertiesGenerator(false);
            ApplicationPropertiesGenerator appPropGen = new ApplicationPropertiesGenerator(propGen);
            String toWrite = appPropGen.getApplicationPropertiesString();
            future.complete(toWrite);
        } else if (COMMAND_UPLOAD_TO_CONFIGMAP_WITHIN_DEVOPS.equals(command)) {
            DevOpsProjectConfigMapUploader.uploadConfigMap(future);
        } else if (COMMAND_UPLOAD_TO_CONFIGMAP.equals(command)) {
            ConfigMapUploader.uploadConfigMap(future);
        }
        return future;
    }
}

