/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import java.util.concurrent.CompletableFuture;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cloud.oracle.NotificationUtils;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.assets.ConfigMapProvider;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.compute.ClusterItem;
import org.netbeans.modules.cloud.oracle.steps.ProjectStep;
import org.netbeans.modules.cloud.oracle.steps.TenancyStep;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class ConfigMapUploader {
    public static void uploadConfigMap(CompletableFuture<Object> future) {
        ClusterItem cluster = CloudAssets.getDefault().getItem(ClusterItem.class);
        if (cluster == null) {
            NotificationUtils.showMessage(Bundle.ClusterNotPresent());
            return;
        }
        Steps.NextStepProvider nsProvider = Steps.NextStepProvider.builder().stepForClass(ProjectStep.class, s -> new TenancyStep()).build();
        Lookup lookup = Lookups.fixed((Object[])new Object[]{nsProvider});
        Steps.getDefault().executeMultistep(new ProjectStep(), lookup).thenAccept(values -> {
            Project project = (Project)values.getValueForStep(ProjectStep.class);
            ProjectInformation projectInfo = ProjectUtils.getInformation((Project)project);
            ConfigMapProvider configMapProvider = new ConfigMapProvider(projectInfo.getDisplayName(), cluster);
            configMapProvider.createConfigMap();
            NotificationUtils.showMessage(Bundle.SuggestRerun());
        });
    }
}

