/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.TenancyInstance;
import org.netbeans.spi.server.ServerInstanceFactory;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class OCITenancyProvider
implements ServerInstanceProvider,
ChangeListener,
PropertyChangeListener {
    private static final String PROPERTY_PROFILE_ID_PREFIX = "profile.id.";
    private static final String PROPERTY_PROFILE_CONFIG_PREFIX = "profile.config.";
    private static final RequestProcessor RP = new RequestProcessor(OCITenancyProvider.class);
    private final ChangeSupport listeners = new ChangeSupport((Object)this);
    private Map<ProfileKey, ServerInstance> instances = new HashMap<ProfileKey, ServerInstance>();
    private static OCITenancyProvider instance;

    private OCITenancyProvider() {
        OCIManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OCIManager.getDefault()));
        RP.post(() -> this.refresh());
    }

    public static synchronized OCITenancyProvider getProvider() {
        if (instance == null) {
            instance = new OCITenancyProvider();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerInstance> getInstances() {
        OCITenancyProvider oCITenancyProvider = this;
        synchronized (oCITenancyProvider) {
            return new ArrayList<ServerInstance>(this.instances.values());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("connectedProfiles".equals(evt.getPropertyName())) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        HashMap<ProfileKey, ServerInstance> newInstances;
        OCITenancyProvider oCITenancyProvider = this;
        synchronized (oCITenancyProvider) {
            newInstances = new HashMap<ProfileKey, ServerInstance>(this.instances);
        }
        ArrayList<ProfileKey> currentKeys = new ArrayList<ProfileKey>();
        for (OCIProfile p : OCIManager.getDefault().getConnectedProfiles()) {
            OCIProfile prevProf;
            ProfileKey k;
            ServerInstance prev;
            String tenanctId = null;
            if (p.getTenancy().isPresent()) {
                tenanctId = p.getTenancy().get().getKey().getValue();
            }
            if ((prev = (ServerInstance)newInstances.get(k = new ProfileKey(p.getConfigPath(), p.getId(), tenanctId))) != null && ((prevProf = (OCIProfile)prev.getLookup().lookup(OCIProfile.class)) == null || prevProf.isValid() != p.isValid())) continue;
            ServerInstance si = ServerInstanceFactory.createServerInstance((ServerInstanceImplementation)new TenancyInstance(p.getTenancy().orElse(null), p));
            newInstances.put(k, si);
            currentKeys.add(k);
        }
        newInstances.keySet().retainAll(currentKeys);
        OCITenancyProvider oCITenancyProvider2 = this;
        synchronized (oCITenancyProvider2) {
            if (this.instances.keySet().equals(newInstances.keySet())) {
                return;
            }
            this.instances = newInstances;
        }
        this.listeners.fireChange();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.removeChangeListener(listener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refresh();
    }

    private static class ProfileKey {
        final Path path;
        final String id;
        final String tenancyId;

        public ProfileKey(Path path, String id, String tenancyId) {
            this.path = path;
            this.id = id;
            this.tenancyId = tenancyId;
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + Objects.hashCode(this.path);
            hash = 29 * hash + Objects.hashCode(this.id);
            hash = 29 * hash + Objects.hashCode(this.tenancyId);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProfileKey other = (ProfileKey)obj;
            if (!Objects.equals(this.id, other.id)) {
                return false;
            }
            if (!Objects.equals(this.tenancyId, other.tenancyId)) {
                return false;
            }
            return Objects.equals(this.path, other.path);
        }
    }
}

