/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring.moveclass;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.jpa.refactoring.PersistenceXmlRefactoring;
import org.netbeans.modules.j2ee.jpa.refactoring.RefactoringUtil;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PersistenceXmlMoveClass
extends PersistenceXmlRefactoring {
    private final MoveRefactoring moveRefactoring;

    public PersistenceXmlMoveClass(MoveRefactoring moveRefactoring) {
        this.moveRefactoring = moveRefactoring;
    }

    @Override
    protected AbstractRefactoring getRefactoring() {
        return this.moveRefactoring;
    }

    @Override
    protected RefactoringElementImplementation getRefactoringElement(PersistenceUnit persistenceUnit, FileObject clazz, PUDataObject pUDataObject, FileObject persistenceXml) {
        String clazzFqn = JavaIdentifiers.getQualifiedName((FileObject)clazz);
        String pkg = this.getTargetPackageName(clazz.getParent());
        String newName = pkg + "." + JavaIdentifiers.unqualify((String)clazzFqn);
        return new PersistenceXmlMoveClassRefactoringElement(persistenceUnit, clazzFqn, newName, pUDataObject, persistenceXml);
    }

    private String getTargetPackageName(FileObject fo) {
        String newPackageName = RefactoringUtil.getPackageName((URL)this.moveRefactoring.getTarget().lookup(URL.class));
        String postfix = "";
        for (FileObject folder : this.getMovedFolders()) {
            if (!FileUtil.isParentOf((FileObject)folder, (FileObject)fo) && !folder.equals(fo)) continue;
            postfix = FileUtil.getRelativePath((FileObject)folder.getParent(), (FileObject)fo).replace('/', '.');
            break;
        }
        if (newPackageName.length() == 0) {
            return postfix;
        }
        if (postfix.length() == 0) {
            return newPackageName;
        }
        return newPackageName + "." + postfix;
    }

    private Set<FileObject> getMovedFolders() {
        Collection fos = this.moveRefactoring.getRefactoringSource().lookupAll(FileObject.class);
        HashSet<FileObject> result = new HashSet<FileObject>();
        for (FileObject each : fos) {
            if (!each.isFolder()) continue;
            result.add(each);
        }
        return result;
    }

    private static class PersistenceXmlMoveClassRefactoringElement
    extends PersistenceXmlRefactoring.PersistenceXmlRefactoringElement {
        private final String newName;

        public PersistenceXmlMoveClassRefactoringElement(PersistenceUnit persistenceUnit, String oldName, String newName, PUDataObject puDataObject, FileObject parentFile) {
            super(persistenceUnit, oldName, puDataObject, parentFile);
            this.newName = newName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.clazz, this.newName};
            return MessageFormat.format(NbBundle.getMessage(PersistenceXmlMoveClassRefactoringElement.class, (String)"TXT_PersistenceXmlRename"), args);
        }

        public void undoChange() {
            ProviderUtil.renameManagedClass((PersistenceUnit)this.persistenceUnit, (String)this.clazz, (String)this.newName, (PUDataObject)this.puDataObject);
        }

        public void performChange() {
            ProviderUtil.renameManagedClass((PersistenceUnit)this.persistenceUnit, (String)this.newName, (String)this.clazz, (PUDataObject)this.puDataObject);
        }
    }
}

