/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.naming.NamingException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.api.ejbjar.ResourceReference;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModelSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.SendEmailPanel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.ServiceLocatorStrategy;
import org.netbeans.modules.j2ee.ejbcore.util._RetoucheUtil;
import org.netbeans.modules.javaee.injection.api.InjectionTargetQuery;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SendEmailCodeGenerator
implements CodeGenerator {
    private FileObject srcFile;
    private TypeElement beanClass;

    static SendEmailCodeGenerator createSendEmailGenerator(JTextComponent component, CompilationController cc, Element el) throws IOException {
        if (el.getKind() != ElementKind.CLASS) {
            return null;
        }
        TypeElement typeElement = (TypeElement)el;
        if (!SendEmailCodeGenerator.isEnable(cc.getFileObject(), typeElement)) {
            return null;
        }
        return new SendEmailCodeGenerator(cc.getFileObject(), typeElement);
    }

    public SendEmailCodeGenerator(FileObject srcFile, TypeElement beanClass) {
        this.srcFile = srcFile;
        this.beanClass = beanClass;
    }

    public void invoke() {
        Project enterpriseProject = FileOwnerQuery.getOwner((FileObject)this.srcFile);
        J2eeModuleProvider pwm = (J2eeModuleProvider)enterpriseProject.getLookup().lookup(J2eeModuleProvider.class);
        pwm.getConfigSupport().ensureConfigurationReady();
        EnterpriseReferenceContainer erc = (EnterpriseReferenceContainer)enterpriseProject.getLookup().lookup(EnterpriseReferenceContainer.class);
        final SendEmailPanel sendEmailPanel = new SendEmailPanel(erc.getServiceLocatorName(), ClasspathInfo.create((FileObject)this.srcFile));
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)sendEmailPanel, NbBundle.getMessage(SendEmailCodeGenerator.class, (String)"LBL_SpecifyMailResource"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(SendEmailPanel.class), null);
        final NotificationLineSupport notificationSupport = dialogDescriptor.createNotificationLineSupport();
        sendEmailPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (evt.getPropertyName().equals("SendEmailPanel_isValid") && (newvalue = evt.getNewValue()) instanceof Boolean) {
                    boolean isValid = (Boolean)newvalue;
                    dialogDescriptor.setValid(isValid);
                    if (isValid) {
                        notificationSupport.clearMessages();
                    } else {
                        notificationSupport.setErrorMessage(sendEmailPanel.getErrorMessage());
                    }
                }
            }
        });
        Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (option == NotifyDescriptor.OK_OPTION) {
            try {
                String serviceLocator = sendEmailPanel.getServiceLocator();
                ServiceLocatorStrategy serviceLocatorStrategy = null;
                if (serviceLocator != null) {
                    serviceLocatorStrategy = ServiceLocatorStrategy.create(enterpriseProject, this.srcFile, serviceLocator);
                }
                String jndiName = null;
                if (!ProjectUtil.isJavaEE5orHigher((Project)enterpriseProject) || !InjectionTargetQuery.isInjectionTarget((FileObject)this.srcFile, (String)this.beanClass.getQualifiedName().toString())) {
                    jndiName = this.generateJNDILookup(sendEmailPanel.getJndiName(), erc, this.srcFile, this.beanClass.getQualifiedName().toString());
                }
                this.generateMethods(enterpriseProject, this.srcFile, this.beanClass.getQualifiedName().toString(), jndiName, sendEmailPanel.getJndiName(), serviceLocatorStrategy);
                if (serviceLocator != null) {
                    erc.setServiceLocatorName(serviceLocator);
                }
            }
            catch (IOException ioe) {
                NotifyDescriptor.Message ndd = new NotifyDescriptor.Message((Object)ioe.getMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)ndd);
            }
        }
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SendEmailCodeGenerator.class, (String)"LBL_SendEmailAction");
    }

    private String generateJNDILookup(String jndiName, EnterpriseReferenceContainer erc, FileObject fileObject, String className) throws IOException {
        ResourceReference resourceReference = ResourceReference.create((String)jndiName, (String)"javax.mail.Session", (String)"Container", (String)"Shareable", null);
        return erc.addResourceRef(resourceReference, fileObject, className);
    }

    private void generateMethods(Project project, FileObject fileObject, String className, String jndiName, String simpleName, ServiceLocatorStrategy slStrategy) throws IOException {
        String memberName = _RetoucheUtil.uniqueMemberName(fileObject, className, simpleName, "mailResource");
        if (jndiName == null) {
            this.generateInjectedField(fileObject, className, simpleName, memberName);
            this.generateSendMailMethod(fileObject, className, memberName, null);
        } else {
            String sessionGetter = this.generateLookupMethod(fileObject, className, jndiName, simpleName, slStrategy);
            this.generateSendMailMethod(fileObject, className, memberName, sessionGetter);
        }
    }

    private void generateSendMailMethod(FileObject fileObject, final String className, String sessionVariableName, String sessionGetter) throws IOException {
        List<MethodModel.Variable> parameters = Arrays.asList(MethodModel.Variable.create((String)"java.lang.String", (String)"email"), MethodModel.Variable.create((String)"java.lang.String", (String)"subject"), MethodModel.Variable.create((String)"java.lang.String", (String)"body"));
        List<String> exceptions = Arrays.asList(NamingException.class.getName(), "javax.mail.MessagingException");
        final MethodModel methodModel = MethodModel.create((String)_RetoucheUtil.uniqueMemberName(fileObject, className, "sendMail", "mailResource"), (String)"void", (String)this.getSendCode(sessionVariableName, sessionGetter), parameters, exceptions, Collections.singleton(Modifier.PRIVATE));
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = workingCopy.getElements().getTypeElement(className);
                MethodTree methodTree = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
                methodTree = (MethodTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importFQNs((Tree)methodTree);
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                ClassTree newClassTree = workingCopy.getTreeMaker().addClassMember(classTree, (Tree)methodTree);
                workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
            }
        }).commit();
    }

    private String getSendCode(String sessionVariableName, String sessionGetter) {
        return (sessionGetter != null ? "javax.mail.Session " + sessionVariableName + " = " + sessionGetter + "();\n" : "") + "javax.mail.internet.MimeMessage message = new javax.mail.internet.MimeMessage(" + sessionVariableName + ");\nmessage.setSubject(subject);\nmessage.setRecipients(javax.mail.Message.RecipientType.TO, javax.mail.internet.InternetAddress.parse(email, false));\nmessage.setText(body);\njavax.mail.Transport.send(message);\n";
    }

    private String generateLookupMethod(FileObject fileObject, final String className, String jndiName, String simpleName, ServiceLocatorStrategy slStrategy) throws IOException {
        String sessionGetter = "get" + simpleName.substring(0, 1).toUpperCase() + simpleName.substring(1);
        sessionGetter = _RetoucheUtil.uniqueMemberName(fileObject, className, sessionGetter, "mailResource");
        String body = null;
        body = slStrategy == null ? this.getSessionCode(jndiName) : this.getSessionCode(jndiName, slStrategy, fileObject, className);
        final MethodModel methodModel = MethodModel.create((String)sessionGetter, (String)"javax.mail.Session", (String)body, Collections.emptyList(), Collections.singletonList(NamingException.class.getName()), Collections.singleton(Modifier.PRIVATE));
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = workingCopy.getElements().getTypeElement(className);
                MethodTree methodTree = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
                methodTree = (MethodTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importFQNs((Tree)methodTree);
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                ClassTree newClassTree = workingCopy.getTreeMaker().addClassMember(classTree, (Tree)methodTree);
                workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
            }
        }).commit();
        return sessionGetter;
    }

    private String getSessionCode(String jndiName, ServiceLocatorStrategy slStrategy, FileObject fileObject, String className) {
        String mailLookupString = slStrategy.genMailSession(jndiName, fileObject, className);
        return "return (javax.mail.Session) " + mailLookupString + ";\n";
    }

    private String getSessionCode(String jndiName) {
        return MessageFormat.format("javax.naming.Context c = new javax.naming.InitialContext();\nreturn (javax.mail.Session) c.lookup(\"java:comp/env/{0}\");\n", jndiName);
    }

    private void generateInjectedField(FileObject fileObject, String className, String jndiName, String simpleName) throws IOException {
        _RetoucheUtil.generateAnnotatedField(fileObject, className, "javax.annotation.Resource", simpleName, "javax.mail.Session", Collections.singletonMap("name", jndiName), InjectionTargetQuery.isStaticReferenceRequired((FileObject)fileObject, (String)className));
    }

    private static boolean isEnable(FileObject fileObject, TypeElement typeElement) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return false;
        }
        if (project.getLookup().lookup(EnterpriseReferenceContainer.class) == null) {
            return false;
        }
        String serverInstanceId = j2eeModuleProvider.getServerInstanceID();
        if (serverInstanceId == null) {
            return true;
        }
        J2eePlatform platform = null;
        try {
            platform = Deployment.getDefault().getServerInstance(serverInstanceId).getJ2eePlatform();
        }
        catch (InstanceRemovedException ex) {
            Logger.getLogger(SendEmailCodeGenerator.class.getName()).log(Level.FINE, null, ex);
        }
        if (platform == null) {
            return true;
        }
        if (!platform.getSupportedTypes().contains(J2eeModule.Type.EJB)) {
            return false;
        }
        return ElementKind.INTERFACE != typeElement.getKind();
    }

    public static TreePath getPathElementOfKind(Tree.Kind kind, TreePath path) {
        return SendEmailCodeGenerator.getPathElementOfKind(EnumSet.of(kind), path);
    }

    public static TreePath getPathElementOfKind(Set<Tree.Kind> kinds, TreePath path) {
        while (path != null) {
            if (kinds.contains((Object)path.getLeaf().getKind())) {
                return path;
            }
            path = path.getParentPath();
        }
        return null;
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<SendEmailCodeGenerator> ret = new ArrayList<SendEmailCodeGenerator>();
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            CompilationController controller = (CompilationController)context.lookup(CompilationController.class);
            TreePath path = (TreePath)context.lookup(TreePath.class);
            TreePath treePath = path = path != null ? SendEmailCodeGenerator.getPathElementOfKind(Tree.Kind.CLASS, path) : null;
            if (component == null || controller == null || path == null) {
                return ret;
            }
            try {
                SendEmailCodeGenerator gen;
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element elem = controller.getTrees().getElement(path);
                if (elem != null && (gen = SendEmailCodeGenerator.createSendEmailGenerator(component, controller, elem)) != null) {
                    ret.add(gen);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return ret;
        }
    }
}

