/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.cmp;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.RelationshipRoleSource;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.OriginalCMPMapping;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.EjbGenerationUtil;
import org.netbeans.modules.j2ee.ejbcore.action.CmFieldGenerator;
import org.netbeans.modules.j2ee.ejbcore.action.FinderMethodGenerator;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.EntityGenerator;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.cmp.CMPMapping;
import org.netbeans.modules.j2ee.ejbcore.naming.EJBNameOptions;
import org.netbeans.modules.j2ee.ejbcore.spi.ProjectPropertiesSupport;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityClass;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.entitygenerator.RelationshipRole;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableSource;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CmpFromDbGenerator {
    private static final String FINDER_EXCEPTION_CLASS = "javax.ejb.FinderException";
    private final Project project;
    private final FileObject ddFileObject;
    private final org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar;
    private final EJBNameOptions ejbnames;

    public CmpFromDbGenerator(Project project, FileObject ddFileObject) throws IOException {
        this.project = project;
        this.ddFileObject = ddFileObject;
        this.ejbJar = DDProvider.getDefault().getDDRoot(ddFileObject);
        this.ejbnames = new EJBNameOptions();
    }

    public void generateBeans(RelatedCMPHelper helper, FileObject dbschemaFile, ProgressNotifier progressNotifier) throws IOException {
        String ejbClassName;
        this.disableSunCmpMappingsExclusion();
        J2eeModuleProvider pwm = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        pwm.getConfigSupport().ensureConfigurationReady();
        if (this.ejbJar.getEnterpriseBeans() == null) {
            EnterpriseBeans eBeans = this.ejbJar.newEnterpriseBeans();
            this.ejbJar.setEnterpriseBeans(eBeans);
        }
        int entityClassIndex = 0;
        int max = 2 * helper.getBeans().length + 4;
        progressNotifier.switchToDeterminate(max);
        OriginalCMPMapping[] mappings = new OriginalCMPMapping[helper.getBeans().length];
        for (EntityClass entityClass : helper.getBeans()) {
            progressNotifier.progress(NbBundle.getMessage(CmpFromDbGenerator.class, (String)"TXT_GeneratingClasses", (Object)entityClass.getClassName()));
            String pkClassName = null;
            ArrayList<EntityMember> primaryKeys = new ArrayList<EntityMember>();
            for (EntityMember entityMember : entityClass.getFields()) {
                if (!entityMember.isPrimaryKey()) continue;
                pkClassName = entityMember.getMemberType();
                primaryKeys.add(entityMember);
            }
            if (primaryKeys.size() > 1) {
                String pkFieldName = this.ejbnames.getEntityPkClassPrefix() + entityClass.getClassName() + this.ejbnames.getEntityPkClassSuffix();
                entityClass.setPkFieldName(pkFieldName);
                pkClassName = Character.toUpperCase(pkFieldName.charAt(0)) + pkFieldName.substring(1);
                GenerationUtils.createClass((String)"Templates/J2EE/EJB21/CmpPrimaryKey.java", (FileObject)entityClass.getPackageFileObject(), (String)pkClassName, null, Collections.singletonMap("seq", primaryKeys));
            } else if (primaryKeys.size() == 1) {
                entityClass.setPkFieldName(((EntityMember)primaryKeys.get(0)).getMemberName());
            }
            String wizardTargetName = entityClass.getClassName();
            EntityGenerator generator = EntityGenerator.create(wizardTargetName, entityClass.getPackageFileObject(), false, true, true, pkClassName, entityClass.getPkFieldName());
            FileObject ejbClassFileObject = generator.generate();
            String packageNameWithDot = EjbGenerationUtil.getSelectedPackageName(entityClass.getPackageFileObject()) + ".";
            progressNotifier.progress(2 * entityClassIndex + 3);
            String ejbClassName2 = packageNameWithDot + this.ejbnames.getEntityEjbClassPrefix() + wizardTargetName + this.ejbnames.getEntityEjbClassSuffix();
            Entity entity = this.findEntityForEjbClass(ejbClassName2);
            FinderMethodGenerator finderGenerator = FinderMethodGenerator.create(ejbClassName2, ejbClassFileObject);
            progressNotifier.progress(NbBundle.getMessage(CmpFromDbGenerator.class, (String)"TXT_GeneratingFinderMethods", (Object)wizardTargetName));
            this.addFinderMethods(finderGenerator, entity, entityClass.getPackageFileObject(), entityClass, helper.isGenerateMappedSuperclasses());
            this.addCmpFields(ejbClassName2, entityClass);
            this.populateEntity(entityClass, entity, wizardTargetName);
            DatabaseConnection dbconn = helper.getDatabaseConnection();
            if (dbconn != null) {
                entity.setDescription(dbconn.getName());
            }
            progressNotifier.progress(NbBundle.getMessage(CmpFromDbGenerator.class, (String)"TXT_PersistingOriginalMapping", (Object)entityClass.getClassName()));
            mappings[entityClassIndex] = new CMPMapping(entity.getEjbName(), entityClass.getCMPMapping(), dbschemaFile);
            progressNotifier.progress(2 * entityClassIndex + 4);
            ++entityClassIndex;
        }
        progressNotifier.progress(NbBundle.getMessage(CmpFromDbGenerator.class, (String)"TXT_GeneratingRelationships"));
        for (EntityClass entityClass : helper.getBeans()) {
            String packageNameWithDot = EjbGenerationUtil.getSelectedPackageName(entityClass.getPackageFileObject()) + ".";
            String wizardTargetName = entityClass.getClassName();
            ejbClassName = packageNameWithDot + this.ejbnames.getEntityEjbClassPrefix() + wizardTargetName + this.ejbnames.getEntityEjbClassSuffix();
            this.addRelationshipFields(ejbClassName, entityClass);
        }
        EntityRelation[] relation = helper.getRelations();
        if (this.ejbJar.getSingleRelationships() == null && relation.length > 0) {
            this.ejbJar.setRelationships(this.ejbJar.newRelationships());
        }
        Relationships rels = this.ejbJar.getSingleRelationships();
        for (int i = 0; i < relation.length; ++i) {
            EjbRelation ejbRel = rels.newEjbRelation();
            this.populateRelation(ejbRel, relation[i]);
            rels.addEjbRelation(ejbRel);
        }
        progressNotifier.progress(max - 1);
        progressNotifier.progress(NbBundle.getMessage(CmpFromDbGenerator.class, (String)"TXT_SavingDeploymentDescriptor"));
        if (pwm != null) {
            try {
                pwm.getConfigSupport().setCMPMappingInfo(mappings);
            }
            catch (ConfigurationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.ejbJar.write(this.ddFileObject);
        if (pwm != null) {
            for (EntityClass entityClass : helper.getBeans()) {
                if (helper.getTableSource().getType() != TableSource.Type.DATA_SOURCE) continue;
                try {
                    ejbClassName = entityClass.getPackage() + '.' + this.ejbnames.getEntityEjbClassPrefix() + entityClass.getClassName() + this.ejbnames.getEntityEjbClassSuffix();
                    Entity entity = this.findEntityForEjbClass(ejbClassName);
                    pwm.getConfigSupport().setCMPResource(entity.getEjbName(), helper.getTableSource().getName());
                }
                catch (ConfigurationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        progressNotifier.progress(max);
    }

    private void addFinderMethods(FinderMethodGenerator generator, Entity entity, FileObject pkg, EntityClass genData, boolean generateLocal) throws IOException {
        FileObject ejbClassFO = pkg.getFileObject(EjbGenerationUtil.getBaseName(entity.getEjbClass()), "java");
        assert (ejbClassFO != null) : "interface class " + entity.getLocalHome() + " not found in " + pkg;
        for (EntityMember entityMember : genData.getFields()) {
            if (!entityMember.supportsFinder()) continue;
            String methodName = "findBy" + EntityMember.makeClassName((String)entityMember.getMemberName());
            MethodModel.Variable parameter = MethodModel.Variable.create((String)entityMember.getMemberType(), (String)entityMember.getMemberName());
            MethodModel methodModel = MethodModel.create((String)methodName, (String)"java.util.Collection", null, Collections.singletonList(parameter), Collections.singletonList(FINDER_EXCEPTION_CLASS), Collections.emptySet());
            String ejbql = MessageFormat.format("SELECT OBJECT({0}) FROM {1} AS {0} WHERE {0}.{2} = ?1", Character.toLowerCase(entity.getAbstractSchemaName().charAt(0)) + "", entity.getAbstractSchemaName(), entityMember.getMemberName());
            generator.generate(methodModel, generateLocal, false, false, ejbql);
        }
    }

    private void populateEntity(EntityClass bean, Entity entity, String wizardTargetName) {
        if (bean.isUsePkField()) {
            entity.setPrimkeyField(bean.getPkFieldName());
        }
        entity.setAbstractSchemaName(wizardTargetName);
    }

    private void populateRelation(EjbRelation ejbR, EntityRelation entityRelation) {
        RelationshipRole roleA = entityRelation.getRoleA();
        RelationshipRole roleB = entityRelation.getRoleB();
        EjbRelationshipRole ejbRoleA = ejbR.newEjbRelationshipRole();
        EjbRelationshipRole ejbRoleB = ejbR.newEjbRelationshipRole();
        this.populateRole(ejbRoleA, roleA);
        this.populateRole(ejbRoleB, roleB);
        ejbR.setEjbRelationName(entityRelation.getRelationName());
        ejbR.setEjbRelationshipRole(ejbRoleA);
        ejbR.setEjbRelationshipRole2(ejbRoleB);
    }

    private void populateRole(EjbRelationshipRole ejbR, RelationshipRole role) {
        ejbR.setCascadeDelete(role.isCascade());
        RelationshipRoleSource source = ejbR.newRelationshipRoleSource();
        source.setEjbName(this.ejbnames.getEntityEjbNamePrefix() + role.getEntityName() + this.ejbnames.getEntityEjbNameSuffix());
        ejbR.setRelationshipRoleSource(source);
        CmrField cmrField = ejbR.newCmrField();
        cmrField.setCmrFieldName(role.getFieldName());
        if (role.isMany()) {
            ejbR.setMultiplicity("Many");
        } else {
            ejbR.setMultiplicity("One");
        }
        if (role.isToMany()) {
            cmrField.setCmrFieldType(Collection.class.getName());
        }
        ejbR.setCmrField(cmrField);
        ejbR.setEjbRelationshipRoleName(role.getEntityName());
    }

    private String getCmrFieldType(RelationshipRole role, String pkg) {
        if (role.isToMany()) {
            return Collection.class.getName();
        }
        RelationshipRole roleA = role.getParent().getRoleA();
        RelationshipRole roleB = role.getParent().getRoleB();
        RelationshipRole otherRole = role.equals(roleA) ? roleB : roleA;
        EJBNameOptions ejbNames = new EJBNameOptions();
        String ejbClassName = pkg + "." + ejbNames.getEntityEjbClassPrefix() + otherRole.getEntityName() + ejbNames.getEntityEjbClassSuffix();
        Entity entity = (Entity)this.ejbJar.getEnterpriseBeans().findBeanByName("Entity", "EjbClass", ejbClassName);
        return entity.getLocal();
    }

    private void disableSunCmpMappingsExclusion() {
        if (EjbJar.getEjbJars((Project)this.project).length == 0) {
            return;
        }
        ProjectPropertiesSupport projectPropertiesSupport = (ProjectPropertiesSupport)this.project.getLookup().lookup(ProjectPropertiesSupport.class);
        if (projectPropertiesSupport != null) {
            projectPropertiesSupport.disableSunCmpMappingExclusion();
        }
    }

    private void addCmpFields(String ejbClass, EntityClass entityClass) throws IOException {
        EJBNameOptions ejbNames = new EJBNameOptions();
        String className = ejbNames.getEntityEjbClassPrefix() + entityClass.getClassName() + ejbNames.getEntityEjbClassSuffix();
        FileObject ejbClassFO = entityClass.getPackageFileObject().getFileObject(EjbGenerationUtil.getBaseName(className), "java");
        CmFieldGenerator generator = CmFieldGenerator.create(ejbClass, ejbClassFO);
        for (EntityMember m : entityClass.getFields()) {
            generator.addCmpField(MethodModel.Variable.create((String)m.getMemberType(), (String)m.getMemberName()), true, true, false, false, null);
        }
    }

    private void addRelationshipFields(String ejbClass, EntityClass entityClass) throws IOException {
        FileObject ejbClassFO = entityClass.getPackageFileObject().getFileObject(EjbGenerationUtil.getBaseName(ejbClass), "java");
        CmFieldGenerator generator = CmFieldGenerator.create(ejbClass, ejbClassFO);
        for (RelationshipRole role : entityClass.getRoles()) {
            String cmrFieldType = this.getCmrFieldType(role, entityClass.getPackage());
            MethodModel.Variable field = MethodModel.Variable.create((String)cmrFieldType, (String)role.getFieldName());
            generator.addFieldToClass(field, true, true, false, false);
        }
    }

    private Entity findEntityForEjbClass(String className) throws IOException {
        EnterpriseBeans enterpriseBeans;
        if (this.ejbJar != null && (enterpriseBeans = this.ejbJar.getEnterpriseBeans()) != null) {
            return (Entity)enterpriseBeans.findBeanByName("Entity", "EjbClass", className);
        }
        return null;
    }

    public static interface ProgressNotifier {
        public void switchToDeterminate(int var1);

        public void progress(int var1);

        public void progress(String var1);
    }
}

