/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class MessageFactory {
    private static String DEFAULT_BUNDLE_BASENAME = "javax.faces.Messages";
    private static String PRIMEFACES_BUNDLE_BASENAME = "org.primefaces.Messages";
    private static String DEFAULT_DETAIL_SUFFIX = "_detail";

    private MessageFactory() {
    }

    public static FacesMessage getMessage(String messageId, FacesMessage.Severity severity, Object[] params) {
        FacesMessage facesMessage = MessageFactory.getMessage(MessageFactory.getLocale(), messageId, params);
        facesMessage.setSeverity(severity);
        return facesMessage;
    }

    public static FacesMessage getMessage(Locale locale, String messageId, Object[] params) {
        String summary = null;
        String detail = null;
        String userBundleName = FacesContext.getCurrentInstance().getApplication().getMessageBundle();
        ResourceBundle bundle = null;
        if (userBundleName != null) {
            try {
                bundle = ResourceBundle.getBundle(userBundleName, locale, MessageFactory.getCurrentClassLoader(userBundleName));
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = ResourceBundle.getBundle(PRIMEFACES_BUNDLE_BASENAME, locale, MessageFactory.getCurrentClassLoader(PRIMEFACES_BUNDLE_BASENAME));
                if (bundle == null) {
                    throw new NullPointerException();
                }
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = ResourceBundle.getBundle(DEFAULT_BUNDLE_BASENAME, locale, MessageFactory.getCurrentClassLoader(DEFAULT_BUNDLE_BASENAME));
                if (bundle == null) {
                    throw new NullPointerException();
                }
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        summary = MessageFactory.getFormattedText(locale, summary, params);
        try {
            detail = MessageFactory.getFormattedText(locale, bundle.getString(messageId + DEFAULT_DETAIL_SUFFIX), params);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return new FacesMessage(summary, detail);
    }

    public static String getFormattedText(Locale locale, String message, Object[] params) {
        MessageFormat messageFormat = null;
        if (params == null || message == null) {
            return message;
        }
        messageFormat = locale != null ? new MessageFormat(message, locale) : new MessageFormat(message);
        return messageFormat.format(params);
    }

    public static Object getLabel(FacesContext facesContext, UIComponent component) {
        String label = (String)component.getAttributes().get("label");
        if (label == null) {
            label = component.getClientId(facesContext);
        }
        return label;
    }

    protected static ClassLoader getCurrentClassLoader(Object clazz) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = clazz.getClass().getClassLoader();
        }
        return loader;
    }

    protected static Locale getLocale() {
        Locale locale = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && facesContext.getViewRoot() != null) {
            locale = facesContext.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

