/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.breakpoints.BreakpointsHandler;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointsInfo;
import org.openide.filesystems.FileObject;

public class CDTBreakpointsActiveService
implements JSBreakpointsInfo {
    public static final String JS_MIME_TYPE = "text/javascript";
    public static final String TS_MIME_TYPE = "application/x-typescript";
    private volatile boolean active = true;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public CDTBreakpointsActiveService() {
        SessionActiveListener sal = new SessionActiveListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentSession", (DebuggerManagerListener)sal);
    }

    public boolean isAnnotatable(FileObject fo) {
        String mimeType = fo.getMIMEType();
        return JS_MIME_TYPE.equals(mimeType) || TS_MIME_TYPE.equals(mimeType);
    }

    public boolean isTransientURL(URL url) {
        return "js-scripts".equals(url.getProtocol());
    }

    public boolean areBreakpointsActivated() {
        return this.active;
    }

    private void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.pcs.firePropertyChange("breakpointsActive", !active, active);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private class SessionActiveListener
    extends DebuggerManagerAdapter
    implements BreakpointsHandler.BreakpointsActiveListener {
        private BreakpointsHandler bh = this.getCurrentBreakpointsHandler();

        public SessionActiveListener() {
            if (this.bh != null) {
                CDTBreakpointsActiveService.this.active = this.bh.areBreakpointsActive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("currentSession".equals(propertyName)) {
                BreakpointsHandler newBh = this.getCurrentBreakpointsHandler();
                SessionActiveListener sessionActiveListener = this;
                synchronized (sessionActiveListener) {
                    if (this.bh != null) {
                        this.bh.removeBreakpointsActiveListener(this);
                    }
                    this.bh = newBh;
                }
                if (newBh != null) {
                    CDTBreakpointsActiveService.this.setActive(newBh.areBreakpointsActive());
                } else {
                    CDTBreakpointsActiveService.this.setActive(true);
                }
            }
        }

        @Override
        public void breakpointsActivated(boolean activated) {
            CDTBreakpointsActiveService.this.setActive(activated);
        }

        private BreakpointsHandler getCurrentBreakpointsHandler() {
            Session s = DebuggerManager.getDebuggerManager().getCurrentSession();
            if (s != null) {
                CDTDebugger debugger = (CDTDebugger)s.lookupFirst(null, CDTDebugger.class);
                if (debugger != null) {
                    BreakpointsHandler bh = debugger.getBreakpointsHandler();
                    bh.addBreakpointsActiveListener(this);
                    return bh;
                }
                return null;
            }
            return null;
        }
    }
}

