/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyDebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.util.WeakListeners;

public class FileMoveBreakpointsHandler
implements LazyDebuggerManagerListener {
    private static final Logger LOG = Logger.getLogger(FileMoveBreakpointsHandler.class.getName());
    private final Map<Breakpoint, BreakpointHandler> handlerMap = new HashMap<Breakpoint, BreakpointHandler>();
    private final ThreadLocal<BreakpointHandler> preferedHandler = new ThreadLocal();

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointAdded(Breakpoint breakpoint) {
        if (breakpoint instanceof LineBreakpoint) {
            LineBreakpoint lb = (LineBreakpoint)breakpoint;
            BreakpointHandler bh = this.preferedHandler.get();
            if (bh == null) {
                bh = new BreakpointHandler(lb);
            }
            Map<Breakpoint, BreakpointHandler> map = this.handlerMap;
            synchronized (map) {
                this.handlerMap.put(breakpoint, bh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof LineBreakpoint) {
            BreakpointHandler bh;
            LineBreakpoint lb = (LineBreakpoint)breakpoint;
            Map<Breakpoint, BreakpointHandler> map = this.handlerMap;
            synchronized (map) {
                bh = this.handlerMap.remove(lb);
            }
            if (bh != null) {
                bh.removed();
            }
        }
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private class BreakpointHandler
    implements PropertyChangeListener,
    ChangeListener {
        private final LineBreakpoint lb;
        private FileObject fo;
        private ChangeListener registryListener;
        private WeakReference<DataObject> dobjRef;
        private PropertyChangeListener dobjwl;
        private boolean fileWasDeleted;

        public BreakpointHandler(LineBreakpoint lb) {
            this.lb = lb;
            lb.addPropertyChangeListener("url", (PropertyChangeListener)this);
            this.handleURL(lb.getURL());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleURL(String url) {
            FileObject newFO = null;
            if (url.length() > 0) {
                try {
                    newFO = URLMapper.findFileObject((URL)new URL(url));
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.WARNING, "URL = '" + url + "'", ex);
                }
                catch (IllegalArgumentException ex) {
                    LOG.log(Level.WARNING, "URL = '" + url + "'", ex);
                }
            }
            BreakpointHandler breakpointHandler = this;
            synchronized (breakpointHandler) {
                this.fo = newFO;
                if (this.dobjRef != null) {
                    DataObject dobj = (DataObject)this.dobjRef.get();
                    if (dobj != null) {
                        dobj.removePropertyChangeListener(this.dobjwl);
                    }
                    this.dobjRef = null;
                    this.dobjwl = null;
                }
                if (newFO != null && this.registryListener == null) {
                    this.registryListener = WeakListeners.change((ChangeListener)this, (Object)DataObject.getRegistry());
                    DataObject.getRegistry().addChangeListener(this.registryListener);
                } else if (newFO == null && this.registryListener != null) {
                    DataObject.getRegistry().removeChangeListener(this.registryListener);
                    this.registryListener = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removed() {
            this.lb.removePropertyChangeListener("url", (PropertyChangeListener)this);
            BreakpointHandler breakpointHandler = this;
            synchronized (breakpointHandler) {
                FileObject theFO = this.fo;
                if (theFO == null) {
                    return;
                }
                boolean valid = theFO.isValid();
                if (valid) {
                    if (this.dobjRef != null) {
                        DataObject dobj = (DataObject)this.dobjRef.get();
                        if (dobj != null) {
                            dobj.removePropertyChangeListener(this.dobjwl);
                        }
                        this.dobjRef = null;
                        this.dobjwl = null;
                    }
                    if (this.registryListener != null) {
                        DataObject.getRegistry().removeChangeListener(this.registryListener);
                        this.registryListener = null;
                    }
                } else {
                    this.fileWasDeleted = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == this.lb) {
                this.handleURL(this.lb.getURL());
            } else if ("primaryFile".equals(evt.getPropertyName())) {
                FileObject newFO = ((DataObject)evt.getSource()).getPrimaryFile();
                boolean addBack = false;
                BreakpointHandler breakpointHandler = this;
                synchronized (breakpointHandler) {
                    this.fo = newFO;
                    if (this.fileWasDeleted) {
                        addBack = true;
                        this.fileWasDeleted = false;
                    }
                }
                this.lb.setURL(newFO.toURL().toString());
                if (addBack) {
                    try {
                        FileMoveBreakpointsHandler.this.preferedHandler.set(this);
                        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.lb);
                        this.lb.addPropertyChangeListener("url", (PropertyChangeListener)this);
                    }
                    finally {
                        FileMoveBreakpointsHandler.this.preferedHandler.remove();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (source instanceof Collection) {
                FileObject bfo = this.fo;
                if (bfo == null) {
                    return;
                }
                for (Object obj : (Collection)source) {
                    DataObject dobj = (DataObject)obj;
                    FileObject primary = dobj.getPrimaryFile();
                    if (!bfo.equals(primary)) continue;
                    BreakpointHandler breakpointHandler = this;
                    synchronized (breakpointHandler) {
                        this.dobjRef = new WeakReference<DataObject>(dobj);
                        this.dobjwl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)dobj);
                        dobj.addPropertyChangeListener(this.dobjwl);
                        if (this.registryListener != null) {
                            DataObject.getRegistry().removeChangeListener(this.registryListener);
                            this.registryListener = null;
                        }
                        break;
                    }
                }
            }
        }
    }
}

