/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.responses;

import com.oracle.bmc.responses.BmcResponse;
import com.oracle.bmc.vault.model.SecretVersion;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetSecretVersionResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private SecretVersion secretVersion;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SecretVersion getSecretVersion() {
        return this.secretVersion;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "secretVersion"})
    private GetSecretVersionResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, SecretVersion secretVersion) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.secretVersion = secretVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",secretVersion=").append(String.valueOf((Object)this.secretVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSecretVersionResponse)) {
            return false;
        }
        GetSecretVersionResponse other = (GetSecretVersionResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.secretVersion, (Object)other.secretVersion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.secretVersion == null ? 43 : this.secretVersion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetSecretVersionResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private SecretVersion secretVersion;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder secretVersion(SecretVersion secretVersion) {
            this.secretVersion = secretVersion;
            return this;
        }

        public Builder copy(GetSecretVersionResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.secretVersion(o.getSecretVersion());
            return this;
        }

        public GetSecretVersionResponse build() {
            return new GetSecretVersionResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.secretVersion);
        }
    }
}

