/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.api.actions.Editable;
import org.netbeans.api.actions.Openable;
import org.netbeans.swing.laf.flatlaf.FlatLafOptionsPanelController;
import org.netbeans.swing.laf.flatlaf.FlatLafPrefs;
import org.openide.LifecycleManager;
import org.openide.awt.ColorComboBox;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FlatLafOptionsPanel
extends JPanel {
    private static final Color DEFAULT = new Color(0, true);
    private static final Color currentAccentColor = FlatLafOptionsPanel.getPrefsAccentColorOrDefault();
    private static final boolean currentUseWindowDecorations = FlatLafPrefs.isUseWindowDecorations();
    private static final RequestProcessor RP = new RequestProcessor(FlatLafOptionsPanel.class);
    private final FlatLafOptionsPanelController controller;
    private static Notification restartNotification;
    private ColorComboBox accentColorField;
    private JLabel accentColorLabel;
    private JPanel advPanel;
    private JCheckBox alwaysShowMnemonicsCheckBox;
    private JButton customPropertiesButton;
    private JLabel customPropertiesLabel;
    private JCheckBox menuBarEmbeddedCheckBox;
    private JLabel needsRestartLabel;
    private JCheckBox showFileChooserFavoritesCheckBox;
    private JCheckBox underlineMenuSelectionCheckBox;
    private JCheckBox unifiedTitleBarCheckBox;
    private JCheckBox useWindowDecorationsCheckBox;

    public FlatLafOptionsPanel(FlatLafOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.initAccentColor();
        this.updateEnabled();
    }

    private void initAccentColor() {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Color> colors = new ArrayList<Color>();
        names.add("default");
        colors.add(DEFAULT);
        String s = UIManager.getString("nb.accentColors.predefined");
        if (s == null) {
            Properties properties = new Properties();
            try {
                properties.load(this.getClass().getClassLoader().getResourceAsStream("org/netbeans/swing/laf/flatlaf/FlatLaf.properties"));
                s = properties.getProperty("nb.accentColors.predefined");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (s != null) {
            for (String part : s.split(";")) {
                Color color;
                int sepIndex = part.indexOf(58);
                if (sepIndex < 1) continue;
                String name = part.substring(0, sepIndex).trim();
                String value = part.substring(sepIndex + 1).trim();
                if (name.isEmpty() || value.isEmpty() || (color = FlatLafPrefs.parseColor(value)) == null) continue;
                names.add(name);
                colors.add(color);
            }
        }
        this.accentColorField.setModel(colors.toArray(new Color[0]), names.toArray(new String[0]));
    }

    private void updateEnabled() {
        boolean supportsWindowDecorations = FlatLaf.supportsNativeWindowDecorations() || new FlatLightLaf().getSupportsWindowDecorations();
        this.useWindowDecorationsCheckBox.setEnabled(supportsWindowDecorations);
        this.unifiedTitleBarCheckBox.setEnabled(supportsWindowDecorations && this.useWindowDecorationsCheckBox.isSelected());
        this.menuBarEmbeddedCheckBox.setEnabled(supportsWindowDecorations && this.useWindowDecorationsCheckBox.isSelected());
        this.underlineMenuSelectionCheckBox.setEnabled(!SystemInfo.isMacOS);
    }

    private void initComponents() {
        this.accentColorLabel = new JLabel();
        this.accentColorField = new ColorComboBox();
        this.needsRestartLabel = new JLabel();
        this.useWindowDecorationsCheckBox = new JCheckBox();
        this.menuBarEmbeddedCheckBox = new JCheckBox();
        this.unifiedTitleBarCheckBox = new JCheckBox();
        this.underlineMenuSelectionCheckBox = new JCheckBox();
        this.alwaysShowMnemonicsCheckBox = new JCheckBox();
        this.advPanel = new JPanel();
        this.customPropertiesLabel = new JLabel();
        this.customPropertiesButton = new JButton();
        this.showFileChooserFavoritesCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Mnemonics.setLocalizedText((JLabel)this.accentColorLabel, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.accentColorLabel.text"));
        this.accentColorField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.accentColorFieldActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.needsRestartLabel, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.needsRestartLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.useWindowDecorationsCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.useWindowDecorationsCheckBox.text"));
        this.useWindowDecorationsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.useWindowDecorationsCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.menuBarEmbeddedCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.menuBarEmbeddedCheckBox.text"));
        this.menuBarEmbeddedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.menuBarEmbeddedCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.unifiedTitleBarCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.unifiedTitleBarCheckBox.text"));
        this.unifiedTitleBarCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.unifiedTitleBarCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.underlineMenuSelectionCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.underlineMenuSelectionCheckBox.text"));
        this.underlineMenuSelectionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.underlineMenuSelectionCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.alwaysShowMnemonicsCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.alwaysShowMnemonicsCheckBox.text"));
        this.alwaysShowMnemonicsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.alwaysShowMnemonicsCheckBoxActionPerformed(evt);
            }
        });
        this.advPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.Advanced.title")));
        Mnemonics.setLocalizedText((JLabel)this.customPropertiesLabel, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.customPropertiesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.customPropertiesButton, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.customPropertiesButton.text"));
        this.customPropertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.customPropertiesButtonActionPerformed(evt);
            }
        });
        GroupLayout advPanelLayout = new GroupLayout(this.advPanel);
        this.advPanel.setLayout(advPanelLayout);
        advPanelLayout.setHorizontalGroup(advPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advPanelLayout.createSequentialGroup().addContainerGap().addGroup(advPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customPropertiesLabel, -2, 368, Short.MAX_VALUE).addGroup(advPanelLayout.createSequentialGroup().addComponent(this.customPropertiesButton).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        advPanelLayout.setVerticalGroup(advPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.customPropertiesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.customPropertiesButton).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((AbstractButton)this.showFileChooserFavoritesCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.showFileChooserFavoritesCheckBox.text"));
        this.showFileChooserFavoritesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.showFileChooserFavoritesCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.advPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useWindowDecorationsCheckBox).addComponent(this.unifiedTitleBarCheckBox).addComponent(this.menuBarEmbeddedCheckBox).addComponent(this.underlineMenuSelectionCheckBox).addComponent(this.alwaysShowMnemonicsCheckBox).addGroup(layout.createSequentialGroup().addComponent(this.accentColorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.accentColorField, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.needsRestartLabel)).addComponent(this.showFileChooserFavoritesCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.accentColorField, -2, -1, -2).addComponent(this.needsRestartLabel).addComponent(this.accentColorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.useWindowDecorationsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unifiedTitleBarCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.menuBarEmbeddedCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.underlineMenuSelectionCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alwaysShowMnemonicsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showFileChooserFavoritesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.advPanel, -2, -1, -2).addContainerGap(42, Short.MAX_VALUE)));
    }

    private void useWindowDecorationsCheckBoxActionPerformed(ActionEvent evt) {
        this.updateEnabled();
        this.fireChanged();
    }

    private void unifiedTitleBarCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChanged();
    }

    private void menuBarEmbeddedCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChanged();
    }

    private void underlineMenuSelectionCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChanged();
    }

    private void alwaysShowMnemonicsCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChanged();
    }

    private void customPropertiesButtonActionPerformed(ActionEvent evt) {
        RP.execute(() -> {
            try {
                DataObject dob;
                Editable editable;
                FileObject lafFolder = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)"LookAndFeel");
                FileObject customProp = lafFolder.getFileObject("FlatLaf.properties");
                if (customProp == null) {
                    customProp = lafFolder.createData("FlatLaf.properties");
                    try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(customProp.getOutputStream()));){
                        writer.append(NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.customProperties.content"));
                    }
                }
                if ((editable = (Editable)(dob = DataObject.find((FileObject)customProp)).getLookup().lookup(Editable.class)) != null) {
                    editable.edit();
                } else {
                    Openable openable = (Openable)dob.getLookup().lookup(Openable.class);
                    openable.open();
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    private void accentColorFieldActionPerformed(ActionEvent evt) {
        this.fireChanged();
    }

    private void showFileChooserFavoritesCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChanged();
    }

    private void fireChanged() {
        boolean isChanged = false;
        if (!Objects.equals(this.accentColorField.getSelectedColor(), FlatLafOptionsPanel.getPrefsAccentColorOrDefault()) || this.useWindowDecorationsCheckBox.isSelected() != FlatLafPrefs.isUseWindowDecorations() || this.unifiedTitleBarCheckBox.isSelected() != FlatLafPrefs.isUnifiedTitleBar() || this.menuBarEmbeddedCheckBox.isSelected() != FlatLafPrefs.isMenuBarEmbedded() || this.underlineMenuSelectionCheckBox.isSelected() != FlatLafPrefs.isUnderlineMenuSelection() || this.alwaysShowMnemonicsCheckBox.isSelected() != FlatLafPrefs.isAlwaysShowMnemonics() || this.showFileChooserFavoritesCheckBox.isSelected() != FlatLafPrefs.isShowFileChooserFavorites()) {
            isChanged = true;
        }
        this.controller.changed(isChanged);
    }

    protected void load() {
        this.accentColorField.setSelectedColor(FlatLafOptionsPanel.getPrefsAccentColorOrDefault());
        this.useWindowDecorationsCheckBox.setSelected(FlatLafPrefs.isUseWindowDecorations());
        this.unifiedTitleBarCheckBox.setSelected(FlatLafPrefs.isUnifiedTitleBar());
        this.menuBarEmbeddedCheckBox.setSelected(FlatLafPrefs.isMenuBarEmbedded());
        this.underlineMenuSelectionCheckBox.setSelected(FlatLafPrefs.isUnderlineMenuSelection());
        this.alwaysShowMnemonicsCheckBox.setSelected(FlatLafPrefs.isAlwaysShowMnemonics());
        this.showFileChooserFavoritesCheckBox.setSelected(FlatLafPrefs.isShowFileChooserFavorites());
        this.updateEnabled();
    }

    protected boolean store() {
        Color accentColor = this.accentColorField.getSelectedColor();
        FlatLafPrefs.setAccentColor(accentColor != DEFAULT ? accentColor : null);
        FlatLafPrefs.setUseWindowDecorations(this.useWindowDecorationsCheckBox.isSelected());
        FlatLafPrefs.setUnifiedTitleBar(this.unifiedTitleBarCheckBox.isSelected());
        FlatLafPrefs.setMenuBarEmbedded(this.menuBarEmbeddedCheckBox.isSelected());
        FlatLafPrefs.setUnderlineMenuSelection(this.underlineMenuSelectionCheckBox.isSelected());
        FlatLafPrefs.setAlwaysShowMnemonics(this.alwaysShowMnemonicsCheckBox.isSelected());
        FlatLafPrefs.setShowFileChooserFavorites(this.showFileChooserFavoritesCheckBox.isSelected());
        if (!Objects.equals(accentColor, currentAccentColor) || SystemInfo.isLinux && this.useWindowDecorationsCheckBox.isSelected() != currentUseWindowDecorations) {
            this.askForRestart();
        }
        return false;
    }

    private void askForRestart() {
        if (restartNotification != null) {
            restartNotification.clear();
        }
        restartNotification = NotificationDisplayer.getDefault().notify(NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.restartTitle"), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/core/windows/resources/restart.png", (boolean)true), NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.restartDetails"), e -> {
            if (restartNotification != null) {
                restartNotification.clear();
                restartNotification = null;
            }
            LifecycleManager.getDefault().markForRestart();
            LifecycleManager.getDefault().exit();
        }, NotificationDisplayer.Priority.NORMAL, NotificationDisplayer.Category.INFO);
    }

    private static Color getPrefsAccentColorOrDefault() {
        Color accentColor = FlatLafPrefs.getAccentColor();
        return accentColor != null ? accentColor : DEFAULT;
    }

    boolean valid() {
        return true;
    }
}

