/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public class ResourceModifier {
    private static final String SUN_RESOURCES_XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE resources PUBLIC \"-//Sun Microsystems, Inc.//DTD Application Server 9.0 Resource Definitions //EN\" \"http://www.sun.com/software/appserver/dtds/sun-resources_1_3.dtd\">\n<resources>\n";
    private static final String GF_RESOURCES_XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE resources PUBLIC \"-//GlassFish.org//DTD GlassFish Application Server 3.1 Resource Definitions//EN\" \"http://glassfish.org/dtds/glassfish-resources_1_5.dtd\">\n<resources>\n";
    private static final String SUN_RESOURCES_XML_FOOTER = "</resources>\n";

    public static void appendAttr(StringBuilder builder, String name, String value, boolean force) {
        if (force || name != null && name.length() > 0) {
            builder.append(name);
            builder.append("=\"");
            builder.append(value);
            builder.append("\" ");
        }
    }

    public static void appendProperty(StringBuilder builder, String name, String value, boolean force) {
        if (force || value != null && value.length() > 0) {
            builder.append("        <property name=\"");
            builder.append(name);
            builder.append("\" value=\"");
            builder.append(value);
            builder.append("\"/>\n");
        }
    }

    public static void appendResource(File sunResourcesXml, String fragment) throws IOException {
        String sunResourcesBuf = ResourceModifier.readResourceFile(sunResourcesXml);
        sunResourcesBuf = sunResourcesXml.getAbsolutePath().contains("sun-resources.xml") ? ResourceModifier.insertFragment(SUN_RESOURCES_XML_HEADER, sunResourcesBuf, fragment) : ResourceModifier.insertFragment(GF_RESOURCES_XML_HEADER, sunResourcesBuf, fragment);
        ResourceModifier.writeResourceFile(sunResourcesXml, sunResourcesBuf);
    }

    private static String insertFragment(String header, String sunResourcesBuf, String fragment) throws IOException {
        String footer = SUN_RESOURCES_XML_FOOTER;
        boolean insertNewLine = false;
        if (sunResourcesBuf != null) {
            int closeIndex = sunResourcesBuf.indexOf("</resources>");
            if (closeIndex == -1) {
                throw new IOException("Malformed XML");
            }
            header = sunResourcesBuf.substring(0, closeIndex);
            footer = sunResourcesBuf.substring(closeIndex);
            if (closeIndex > 0 && sunResourcesBuf.charAt(closeIndex - 1) != '\n') {
                insertNewLine = true;
            }
        }
        int length = header.length() + footer.length() + 2;
        if (fragment != null) {
            length += fragment.length();
        }
        StringBuilder builder = new StringBuilder(length);
        builder.append(header);
        if (insertNewLine) {
            String lineSeparator = System.getProperty("line.separator");
            builder.append(lineSeparator != null ? lineSeparator : "\n");
        }
        if (fragment != null) {
            builder.append(fragment);
        }
        builder.append(footer);
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readResourceFile(File sunResourcesXml) throws IOException {
        String content = null;
        if (!sunResourcesXml.exists()) return content;
        FileObject sunResourcesFO = FileUtil.toFileObject((File)(sunResourcesXml = FileUtil.normalizeFile((File)sunResourcesXml)));
        if (sunResourcesFO == null) throw new IOException("Unable to get FileObject for " + sunResourcesXml.getAbsolutePath());
        InputStream is = null;
        Reader reader = null;
        try {
            String encoding;
            long flen = sunResourcesFO.getSize();
            if (flen > 1000000L) {
                throw new IOException(sunResourcesXml.getAbsolutePath() + " is too long to update.");
            }
            int length = (int)(2L * flen + 32L);
            char[] buf = new char[length];
            is = new BufferedInputStream(sunResourcesFO.getInputStream());
            reader = new InputStreamReader(is, encoding = EncodingUtil.detectEncoding((InputStream)is));
            int max = reader.read(buf);
            if (max <= 0) return content;
            content = new String(buf, 0, max);
            return content;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void writeResourceFile(File sunResourcesXml, String content) throws IOException {
        FileObject parentFolder = FileUtil.createFolder((File)sunResourcesXml.getParentFile());
        FileSystem fs = parentFolder.getFileSystem();
        ResourceModifier.writeResourceFile(fs, sunResourcesXml, content);
    }

    private static void writeResourceFile(FileSystem fs, final File sunResourcesXml, final String content) throws IOException {
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileLock lock = null;
                BufferedWriter writer = null;
                try {
                    FileObject sunResourcesFO = FileUtil.createData((File)sunResourcesXml);
                    lock = sunResourcesFO.lock();
                    writer = new BufferedWriter(new OutputStreamWriter(sunResourcesFO.getOutputStream(lock)));
                    writer.write(content);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
        });
    }
}

