/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.tools.JavaFileManager;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.classpath.AptSourcePath;
import org.netbeans.modules.java.source.classpath.CacheClassPath;
import org.netbeans.modules.java.source.classpath.SourcePath;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.indexing.TransactionContext;
import org.netbeans.modules.java.source.parsing.FileManagerTransaction;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.MemoryFileManager;
import org.netbeans.modules.java.source.parsing.OutputFileManager;
import org.netbeans.modules.java.source.parsing.ProcessorGenerated;
import org.netbeans.modules.java.source.parsing.ProxyFileManager;
import org.netbeans.modules.java.source.parsing.SiblingSource;
import org.netbeans.modules.java.source.parsing.SiblingSupport;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class ClasspathInfo {
    private static final Logger log;
    private final ClassPath srcClassPath;
    private final ClassPath moduleSrcPath;
    private final ClassPath bootClassPath;
    private final ClassPath moduleBootPath;
    private final ClassPath compileClassPath;
    private final ClassPath moduleCompilePath;
    private final ClassPath moduleClassPath;
    private final ClassPath cachedAptSrcClassPath;
    private final ClassPath cachedSrcClassPath;
    private final ClassPath cachedBootClassPath;
    private final ClassPath cachedCompileClassPath;
    private final ClassPath cachedModuleCompilePath;
    private final ClassPath cachedModuleClassPath;
    private final ClassPath outputClassPath;
    private final ClassPathListener cpListener;
    private final boolean useModifiedFiles;
    private final boolean ignoreExcludes;
    private final JavaFileFilterImplementation filter;
    private final MemoryFileManager memoryFileManager;
    private final ChangeSupport listenerList;
    private final FileManagerTransaction fmTx;
    private final ProcessorGenerated pgTx;
    private final Map<ClassPath, Function<URL, Collection<? extends URL>>> peerProviders;
    private final Function<JavaFileManager.Location, JavaFileManager> jfmProvider;
    private ClassIndex usagesQuery;

    private ClasspathInfo(@NonNull ClassPath bootCp, @NonNull ClassPath moduleBootP, @NonNull ClassPath compileCp, @NonNull ClassPath moduleCompileP, @NonNull ClassPath moduleClassP, @NullAllowed ClassPath srcCp, @NullAllowed ClassPath moduleSrcCp, @NullAllowed JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles, boolean requiresSourceRoots, @NullAllowed Function<JavaFileManager.Location, JavaFileManager> jfmProvider) {
        assert (bootCp != null);
        assert (compileCp != null);
        this.cpListener = new ClassPathListener();
        this.bootClassPath = bootCp;
        this.moduleBootPath = moduleBootP;
        this.compileClassPath = compileCp;
        this.moduleCompilePath = moduleCompileP;
        this.moduleClassPath = moduleClassP;
        this.listenerList = new ChangeSupport((Object)this);
        this.cachedBootClassPath = CacheClassPath.forBootPath(this.bootClassPath, backgroundCompilation);
        this.cachedCompileClassPath = CacheClassPath.forClassPath(this.compileClassPath, backgroundCompilation);
        this.cachedModuleCompilePath = CacheClassPath.forClassPath(this.moduleCompilePath, backgroundCompilation);
        this.cachedModuleClassPath = CacheClassPath.forClassPath(this.moduleClassPath, backgroundCompilation);
        if (!backgroundCompilation) {
            this.cachedBootClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedBootClassPath));
            this.cachedCompileClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedCompileClassPath));
        }
        if (srcCp == null || srcCp == ClassPath.EMPTY) {
            this.outputClassPath = this.cachedAptSrcClassPath = ClassPath.EMPTY;
            this.srcClassPath = this.cachedAptSrcClassPath;
            this.cachedSrcClassPath = this.cachedAptSrcClassPath;
        } else {
            this.srcClassPath = srcCp;
            ClassPathImplementation noApt = AptSourcePath.sources(srcCp);
            this.cachedSrcClassPath = ClassPathFactory.createClassPath((ClassPathImplementation)SourcePath.filtered(noApt, backgroundCompilation));
            this.cachedAptSrcClassPath = ClassPathFactory.createClassPath((ClassPathImplementation)SourcePath.filtered(AptSourcePath.aptCache(srcCp), backgroundCompilation));
            this.outputClassPath = CacheClassPath.forSourcePath(ClassPathFactory.createClassPath((ClassPathImplementation)noApt), backgroundCompilation);
            if (!backgroundCompilation) {
                this.cachedSrcClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedSrcClassPath));
            }
        }
        if (requiresSourceRoots && this.cachedSrcClassPath.entries().isEmpty()) {
            throw new OutputFileManager.InvalidSourcePath();
        }
        this.moduleSrcPath = moduleSrcCp == null ? ClassPath.EMPTY : moduleSrcCp;
        this.ignoreExcludes = ignoreExcludes;
        this.useModifiedFiles = useModifiedFiles;
        this.filter = filter;
        if (hasMemoryFileManager) {
            if (srcCp == null) {
                throw new IllegalStateException();
            }
            this.memoryFileManager = new MemoryFileManager();
        } else {
            this.memoryFileManager = null;
        }
        if (backgroundCompilation) {
            TransactionContext txCtx = TransactionContext.get();
            this.fmTx = txCtx.get(FileManagerTransaction.class);
            this.pgTx = txCtx.get(ProcessorGenerated.class);
        } else {
            this.fmTx = FileManagerTransaction.treeLoaderOnly();
            this.pgTx = ProcessorGenerated.nullWrite();
        }
        this.peerProviders = new IdentityHashMap<ClassPath, Function<URL, Collection<? extends URL>>>();
        this.peerProviders.put(this.cachedModuleCompilePath, new Peers(this.moduleCompilePath));
        assert (this.fmTx != null) : "No file manager transaction.";
        assert (this.pgTx != null) : "No processor generated transaction.";
        this.jfmProvider = jfmProvider;
    }

    public String toString() {
        return String.format("ClasspathInfo [boot: %s, module boot: %s, compile: %s, module compile: %s, module class: %s, src: %s, internal boot: %s, internal compile: %s, internal module class: %s, internal src: %s, internal out: %s]", this.bootClassPath, this.moduleBootPath, this.compileClassPath, this.moduleCompilePath, this.moduleClassPath, this.srcClassPath, this.cachedBootClassPath, this.cachedCompileClassPath, this.cachedModuleClassPath, this.cachedSrcClassPath, this.outputClassPath);
    }

    public int hashCode() {
        return Arrays.hashCode(ClasspathInfo.toURIs(this.srcClassPath));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClasspathInfo)) {
            return false;
        }
        ClasspathInfo other = (ClasspathInfo)obj;
        return Arrays.equals(ClasspathInfo.toURIs(this.srcClassPath), ClasspathInfo.toURIs(other.srcClassPath)) && Arrays.equals(ClasspathInfo.toURIs(this.compileClassPath), ClasspathInfo.toURIs(other.compileClassPath)) && Arrays.equals(ClasspathInfo.toURIs(this.bootClassPath), ClasspathInfo.toURIs(other.bootClassPath)) && Arrays.equals(ClasspathInfo.toURIs(this.moduleBootPath), ClasspathInfo.toURIs(other.moduleBootPath)) && Arrays.equals(ClasspathInfo.toURIs(this.moduleCompilePath), ClasspathInfo.toURIs(other.moduleCompilePath)) && Arrays.equals(ClasspathInfo.toURIs(this.moduleClassPath), ClasspathInfo.toURIs(other.moduleClassPath));
    }

    @NullUnknown
    public static ClasspathInfo create(@NonNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot pass null as parameter of ClasspathInfo.create(java.io.File)");
        }
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return null;
        }
        return ClasspathInfo.create(fo);
    }

    @NullUnknown
    public static ClasspathInfo create(@NonNull Document doc) {
        Parameters.notNull((CharSequence)"doc", (Object)doc);
        FileObject fileObject = Utilities.getFileObject((Document)doc);
        if (fileObject != null) {
            return ClasspathInfo.create(fileObject);
        }
        return null;
    }

    @NonNull
    public static ClasspathInfo create(@NonNull FileObject fo) {
        return ClasspathInfo.create(fo, null, false, false, false, true);
    }

    @NonNull
    public static ClasspathInfo create(@NonNull ClassPath bootPath, @NonNull ClassPath classPath, @NullAllowed ClassPath sourcePath) {
        Parameters.notNull((CharSequence)"bootPath", (Object)bootPath);
        Parameters.notNull((CharSequence)"classPath", (Object)classPath);
        return new Builder(bootPath).setClassPath(classPath).setSourcePath(sourcePath).build();
    }

    @NonNull
    private static ClasspathInfo create(@NonNull FileObject fo, @NullAllowed JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles) {
        ClassPath moduleClassPath;
        ClassPath moduleCompilePath;
        ClassPath compilePath;
        ClassPath moduleBootPath;
        ClassPath bootPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot");
        if (bootPath == null) {
            bootPath = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
        }
        if ((moduleBootPath = ClassPath.getClassPath((FileObject)fo, (String)"modules/boot")) == null) {
            moduleBootPath = ClassPath.EMPTY;
        }
        if ((compilePath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile")) == null) {
            compilePath = ClassPath.EMPTY;
        }
        if ((moduleCompilePath = ClassPath.getClassPath((FileObject)fo, (String)"modules/compile")) == null) {
            moduleCompilePath = ClassPath.EMPTY;
        }
        if ((moduleClassPath = ClassPath.getClassPath((FileObject)fo, (String)"modules/classpath")) == null) {
            moduleClassPath = ClassPath.EMPTY;
        }
        ClassPath srcPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        ClassPath moduleSrcPath = ClassPath.getClassPath((FileObject)fo, (String)"modules/source");
        return ClasspathInfo.create(bootPath, moduleBootPath, compilePath, moduleCompilePath, moduleClassPath, srcPath, moduleSrcPath, filter, backgroundCompilation, ignoreExcludes, hasMemoryFileManager, useModifiedFiles, false, null);
    }

    @NonNull
    private static ClasspathInfo create(@NonNull ClassPath bootPath, @NonNull ClassPath moduleBootPath, @NonNull ClassPath classPath, @NonNull ClassPath moduleCompilePath, @NonNull ClassPath moduleClassPath, @NullAllowed ClassPath sourcePath, @NullAllowed ClassPath moduleSourcePath, @NullAllowed JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles, boolean requiresSourceRoots, @NullAllowed Function<JavaFileManager.Location, JavaFileManager> jfmProvider) {
        return new ClasspathInfo(bootPath, moduleBootPath, classPath, moduleCompilePath, moduleClassPath, sourcePath, moduleSourcePath, filter, backgroundCompilation, ignoreExcludes, hasMemoryFileManager, useModifiedFiles, requiresSourceRoots, jfmProvider);
    }

    public void addChangeListener(@NonNull ChangeListener listener) {
        this.listenerList.addChangeListener(listener);
    }

    public synchronized void removeChangeListener(@NonNull ChangeListener listener) {
        this.listenerList.removeChangeListener(listener);
    }

    public ClassPath getClassPath(@NonNull PathKind pathKind) {
        switch (pathKind) {
            case BOOT: {
                return this.bootClassPath;
            }
            case MODULE_BOOT: {
                return this.moduleBootPath;
            }
            case COMPILE: {
                return this.compileClassPath;
            }
            case MODULE_COMPILE: {
                return this.moduleCompilePath;
            }
            case MODULE_CLASS: {
                return this.moduleClassPath;
            }
            case SOURCE: {
                return this.srcClassPath;
            }
            case MODULE_SOURCE: {
                return this.moduleSrcPath;
            }
        }
        assert (false) : "Unknown path type";
        return null;
    }

    ClassPath getCachedClassPath(PathKind pathKind) {
        switch (pathKind) {
            case BOOT: {
                return this.cachedBootClassPath;
            }
            case COMPILE: {
                return this.cachedCompileClassPath;
            }
            case MODULE_COMPILE: {
                return this.cachedModuleCompilePath;
            }
            case MODULE_CLASS: {
                return this.cachedModuleClassPath;
            }
            case SOURCE: {
                return this.cachedSrcClassPath;
            }
            case OUTPUT: {
                return this.outputClassPath;
            }
        }
        assert (false) : "Unknown path type";
        return null;
    }

    @NonNull
    public synchronized ClassIndex getClassIndex() {
        if (this.usagesQuery == null) {
            this.usagesQuery = new ClassIndex(this.bootClassPath, this.compileClassPath, this.cachedSrcClassPath);
        }
        return this.usagesQuery;
    }

    @NonNull
    private synchronized JavaFileManager createFileManager(@NullAllowed String sourceLevel) {
        SiblingSource siblings = SiblingSupport.create();
        ProxyFileManager.Configuration cfg = ProxyFileManager.Configuration.create(this.moduleBootPath, this.cachedModuleCompilePath, this.cachedBootClassPath, this.moduleCompilePath.entries().isEmpty() ? this.cachedCompileClassPath : this.cachedModuleClassPath, this.srcClassPath, this.cachedSrcClassPath, this.moduleSrcPath, this.outputClassPath, this.cachedAptSrcClassPath, siblings, this.fmTx, this.pgTx);
        cfg.setFilter(this.filter);
        cfg.setIgnoreExcludes(this.ignoreExcludes);
        cfg.setUseModifiedFiles(this.useModifiedFiles);
        cfg.setCustomFileManagerProvider(this.jfmProvider);
        for (Map.Entry<ClassPath, Function<URL, Collection<? extends URL>>> e : this.peerProviders.entrySet()) {
            cfg.setPeers(e.getKey(), e.getValue());
        }
        cfg.setSourceLevel(sourceLevel);
        return new ProxyFileManager(cfg);
    }

    private void fireChangeListenerStateChanged() {
        this.listenerList.fireChange();
    }

    @CheckForNull
    private static URI[] toURIs(@NullAllowed ClassPath cp) {
        if (cp == null) {
            return null;
        }
        List entries = cp.entries();
        ArrayList<URI> roots = new ArrayList<URI>(entries.size());
        for (ClassPath.Entry entry : entries) {
            try {
                roots.add(entry.getURL().toURI());
            }
            catch (URISyntaxException ex) {
                log.log(Level.INFO, "Cannot convert {0} to URI.", entry.getURL());
            }
        }
        return roots.toArray(new URI[0]);
    }

    static {
        block2: {
            log = Logger.getLogger(ClasspathInfo.class.getName());
            ClasspathInfoAccessor.setINSTANCE(new ClasspathInfoAccessorImpl());
            try {
                Class.forName(ClassIndex.class.getName(), true, CompilationInfo.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                if (!log.isLoggable(Level.SEVERE)) break block2;
                log.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private class ClassPathListener
    implements PropertyChangeListener {
        private ClassPathListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("roots".equals(event.getPropertyName())) {
                ClasspathInfo.this.fireChangeListenerStateChanged();
            }
        }
    }

    private static final class Peers
    implements Function<URL, Collection<? extends URL>>,
    PropertyChangeListener {
        private final ClassPath base;
        private volatile Map<URL, Collection<? extends URL>> cache;

        Peers(@NonNull ClassPath base) {
            assert (base != null);
            this.base = base;
            this.base.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.base));
        }

        @Override
        public Collection<? extends URL> apply(URL t) {
            return this.getCache().getOrDefault(t, Collections.singleton(t));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("entries".equals(evt.getPropertyName())) {
                this.cache = null;
            }
        }

        private Map<URL, Collection<? extends URL>> getCache() {
            Map<URL, Collection<? extends URL>> res = this.cache;
            if (res == null) {
                res = new HashMap<URL, Collection<? extends URL>>();
                PathRegistry pr = PathRegistry.getDefault();
                for (ClassPath.Entry e : this.base.entries()) {
                    Collection cfs;
                    URL[] srcs = pr.sourceForBinaryQuery(e.getURL(), this.base, false);
                    if (srcs == null || (cfs = (Collection)Arrays.stream(srcs).map(u -> {
                        try {
                            return BaseUtilities.toURI((File)JavaIndex.getClassFolder(u)).toURL();
                        }
                        catch (IOException ioe) {
                            return null;
                        }
                    }).filter(u -> u != null).collect(Collectors.toList())).size() <= 1) continue;
                    for (URL u2 : cfs) {
                        res.put(u2, cfs);
                    }
                }
                this.cache = res;
            }
            return res;
        }
    }

    public static final class Builder {
        private final ClassPath bootPath;
        private ClassPath moduleBootPath = ClassPath.EMPTY;
        private ClassPath classPath = ClassPath.EMPTY;
        private ClassPath moduleCompilePath = ClassPath.EMPTY;
        private ClassPath moduleClassPath = ClassPath.EMPTY;
        private ClassPath sourcePath = ClassPath.EMPTY;
        private ClassPath moduleSourcePath = ClassPath.EMPTY;

        public Builder(@NonNull ClassPath bootPath) {
            Parameters.notNull((CharSequence)"bootPath", (Object)bootPath);
            this.bootPath = bootPath;
        }

        @NonNull
        public Builder setModuleBootPath(@NullAllowed ClassPath moduleBootPath) {
            if (moduleBootPath == null) {
                moduleBootPath = ClassPath.EMPTY;
            }
            this.moduleBootPath = moduleBootPath;
            return this;
        }

        @NonNull
        public Builder setClassPath(@NullAllowed ClassPath classPath) {
            if (classPath == null) {
                classPath = ClassPath.EMPTY;
            }
            this.classPath = classPath;
            return this;
        }

        @NonNull
        public Builder setModuleCompilePath(@NullAllowed ClassPath moduleCompilePath) {
            if (moduleCompilePath == null) {
                moduleCompilePath = ClassPath.EMPTY;
            }
            this.moduleCompilePath = moduleCompilePath;
            return this;
        }

        @NonNull
        public Builder setModuleClassPath(@NullAllowed ClassPath moduleClassPath) {
            if (moduleClassPath == null) {
                moduleClassPath = ClassPath.EMPTY;
            }
            this.moduleClassPath = moduleClassPath;
            return this;
        }

        @NonNull
        public Builder setSourcePath(@NullAllowed ClassPath sourcePath) {
            if (sourcePath == null) {
                sourcePath = ClassPath.EMPTY;
            }
            this.sourcePath = sourcePath;
            return this;
        }

        @NonNull
        public Builder setModuleSourcePath(@NullAllowed ClassPath moduleSourcePath) {
            if (moduleSourcePath == null) {
                moduleSourcePath = ClassPath.EMPTY;
            }
            this.moduleSourcePath = moduleSourcePath;
            return this;
        }

        @NonNull
        public ClasspathInfo build() {
            return ClasspathInfo.create(this.bootPath, this.moduleBootPath, this.classPath, this.moduleCompilePath, this.moduleClassPath, this.sourcePath, this.moduleSourcePath, null, false, false, false, true, false, null);
        }
    }

    public static enum PathKind {
        BOOT,
        MODULE_BOOT,
        COMPILE,
        MODULE_COMPILE,
        MODULE_CLASS,
        SOURCE,
        MODULE_SOURCE,
        OUTPUT;

    }

    private static class ClasspathInfoAccessorImpl
    extends ClasspathInfoAccessor {
        private ClasspathInfoAccessorImpl() {
        }

        @Override
        @NonNull
        public JavaFileManager createFileManager(@NonNull ClasspathInfo cpInfo, @NullAllowed String sourceLevel) {
            return cpInfo.createFileManager(sourceLevel);
        }

        @Override
        @NonNull
        public FileManagerTransaction getFileManagerTransaction(@NonNull ClasspathInfo cpInfo) {
            return cpInfo.fmTx;
        }

        @Override
        public ClassPath getCachedClassPath(ClasspathInfo cpInfo, PathKind kind) {
            return cpInfo.getCachedClassPath(kind);
        }

        @Override
        public ClasspathInfo create(@NonNull ClassPath bootPath, @NonNull ClassPath moduleBootPath, @NonNull ClassPath classPath, @NonNull ClassPath moduleCompilePath, @NonNull ClassPath moduleClassPath, @NullAllowed ClassPath sourcePath, @NullAllowed ClassPath moduleSourcePath, @NullAllowed JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles, boolean requiresSourceRoots, @NullAllowed Function<JavaFileManager.Location, JavaFileManager> jfmProvider) {
            return ClasspathInfo.create(bootPath, moduleBootPath, classPath, moduleCompilePath, moduleClassPath, sourcePath, moduleSourcePath, filter, backgroundCompilation, ignoreExcludes, hasMemoryFileManager, useModifiedFiles, requiresSourceRoots, jfmProvider);
        }

        @Override
        public ClasspathInfo create(@NonNull FileObject fo, JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles) {
            return ClasspathInfo.create(fo, filter, backgroundCompilation, ignoreExcludes, hasMemoryFileManager, useModifiedFiles);
        }

        @Override
        public boolean registerVirtualSource(ClasspathInfo cpInfo, InferableJavaFileObject jfo) throws UnsupportedOperationException {
            if (cpInfo.memoryFileManager == null) {
                throw new UnsupportedOperationException("The ClassPathInfo doesn't support memory JavacFileManager");
            }
            return cpInfo.memoryFileManager.register(jfo);
        }

        @Override
        public boolean unregisterVirtualSource(ClasspathInfo cpInfo, String fqn) throws UnsupportedOperationException {
            if (cpInfo.memoryFileManager == null) {
                throw new UnsupportedOperationException();
            }
            return cpInfo.memoryFileManager.unregister(fqn);
        }
    }

    public static interface Provider {
        public ClasspathInfo getClasspathInfo();
    }
}

