/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.Dialog;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FileSelector
extends JPanel
implements ListSelectionListener {
    private DialogDescriptor dialogDescriptor;
    private JButton okButton;
    private JButton cancelButton;
    private final String text;
    private final String title;
    private final HelpCtx helpCtx;
    private final Preferences pref;
    private static final String FILE_SELECTOR_PREFIX = "fileSelector";
    private static final Logger LOG = Logger.getLogger(FileSelector.class.getName());
    final JList filesList = new JList();
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;

    public FileSelector(String text, String title, HelpCtx helpCtx, Preferences pref) {
        this.text = text;
        this.title = title;
        this.helpCtx = helpCtx;
        this.pref = pref;
        this.initComponents();
        this.filesList.addListSelectionListener(this);
        this.dialogDescriptor = new DialogDescriptor((Object)this, title);
        this.okButton = new JButton(NbBundle.getMessage(FileSelector.class, (String)"CTL_FileSelector_Select"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSelector.class, (String)"CTL_FileSelector_Select"));
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(NbBundle.getMessage(FileSelector.class, (String)"CTL_FileSelector_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSelector.class, (String)"CTL_FileSelector_Cancel"));
        this.dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        this.dialogDescriptor.setModal(true);
        this.dialogDescriptor.setHelpCtx(new HelpCtx(this.getClass()));
        this.dialogDescriptor.setValid(false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jLabel1.setText(this.text);
        this.filesList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.filesList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.filesList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 606, Short.MAX_VALUE).addComponent(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 109, Short.MAX_VALUE).addContainerGap()));
    }

    public boolean show(File[] files) {
        boolean ret;
        Arrays.sort(files);
        DefaultListModel<File> m = new DefaultListModel<File>();
        for (File file : files) {
            m.addElement(file);
        }
        this.filesList.setModel(m);
        this.preselectFile(files);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(this.title);
        this.dialogDescriptor.setHelpCtx(this.helpCtx);
        dialog.setVisible(true);
        boolean bl = ret = this.dialogDescriptor.getValue() == this.okButton;
        if (ret) {
            this.saveSelectedFile(files);
        }
        return ret;
    }

    public File getSelectedFile() {
        return (File)this.filesList.getSelectedValue();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean enabled = this.filesList.getSelectedValue() != null;
        this.dialogDescriptor.setValid(enabled);
        this.okButton.setEnabled(enabled);
    }

    private void preselectFile(File[] files) {
        String hash = this.getHash(files);
        if (hash == null || hash.trim().equals("")) {
            return;
        }
        String path = this.getFileSelectorPreset(hash);
        if (path != null && !path.trim().equals("")) {
            File f = new File(path);
            this.filesList.setSelectedValue(f, true);
        }
    }

    private void saveSelectedFile(File[] files) {
        String hash = this.getHash(files);
        if (hash == null || hash.trim().equals("")) {
            return;
        }
        File file = this.getSelectedFile();
        if (file != null) {
            this.setFileSelectorPreset(hash, file.getAbsolutePath());
        }
    }

    private String getHash(File[] files) {
        Arrays.sort(files);
        StringBuffer sb = new StringBuffer();
        for (File file : files) {
            sb.append(file.getAbsolutePath());
        }
        String hash = null;
        try {
            hash = Utils.getHash("MD5", sb.toString().getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return hash;
    }

    public String getFileSelectorPreset(String hash) {
        return this.pref.get("fileSelector-" + hash, "");
    }

    public void setFileSelectorPreset(String hash, String path) {
        this.pref.put("fileSelector-" + hash, path);
    }
}

