/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteTagDefaultRequest
extends BmcRequest<Void> {
    private String tagDefaultId;
    private String opcRequestId;
    private String ifMatch;
    private Boolean isLockOverride;

    public String getTagDefaultId() {
        return this.tagDefaultId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Boolean getIsLockOverride() {
        return this.isLockOverride;
    }

    public Builder toBuilder() {
        return new Builder().tagDefaultId(this.tagDefaultId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).isLockOverride(this.isLockOverride);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",tagDefaultId=").append(String.valueOf(this.tagDefaultId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",isLockOverride=").append(String.valueOf(this.isLockOverride));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteTagDefaultRequest)) {
            return false;
        }
        DeleteTagDefaultRequest other = (DeleteTagDefaultRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.tagDefaultId, other.tagDefaultId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.isLockOverride, other.isLockOverride);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tagDefaultId == null ? 43 : this.tagDefaultId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.isLockOverride == null ? 43 : this.isLockOverride.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteTagDefaultRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String tagDefaultId = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private Boolean isLockOverride = null;

        public Builder tagDefaultId(String tagDefaultId) {
            this.tagDefaultId = tagDefaultId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder isLockOverride(Boolean isLockOverride) {
            this.isLockOverride = isLockOverride;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteTagDefaultRequest o) {
            this.tagDefaultId(o.getTagDefaultId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.isLockOverride(o.getIsLockOverride());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteTagDefaultRequest build() {
            DeleteTagDefaultRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteTagDefaultRequest buildWithoutInvocationCallback() {
            DeleteTagDefaultRequest request = new DeleteTagDefaultRequest();
            request.tagDefaultId = this.tagDefaultId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.isLockOverride = this.isLockOverride;
            return request;
        }
    }
}

