/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.ChangeDomainLicenseTypeDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeDomainLicenseTypeRequest
extends BmcRequest<ChangeDomainLicenseTypeDetails> {
    private String domainId;
    private ChangeDomainLicenseTypeDetails changeDomainLicenseTypeDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    public String getDomainId() {
        return this.domainId;
    }

    public ChangeDomainLicenseTypeDetails getChangeDomainLicenseTypeDetails() {
        return this.changeDomainLicenseTypeDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public ChangeDomainLicenseTypeDetails getBody$() {
        return this.changeDomainLicenseTypeDetails;
    }

    public Builder toBuilder() {
        return new Builder().domainId(this.domainId).changeDomainLicenseTypeDetails(this.changeDomainLicenseTypeDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",domainId=").append(String.valueOf(this.domainId));
        sb.append(",changeDomainLicenseTypeDetails=").append(String.valueOf((Object)this.changeDomainLicenseTypeDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeDomainLicenseTypeRequest)) {
            return false;
        }
        ChangeDomainLicenseTypeRequest other = (ChangeDomainLicenseTypeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.domainId, other.domainId) && Objects.equals((Object)this.changeDomainLicenseTypeDetails, (Object)other.changeDomainLicenseTypeDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.domainId == null ? 43 : this.domainId.hashCode());
        result = result * 59 + (this.changeDomainLicenseTypeDetails == null ? 43 : this.changeDomainLicenseTypeDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeDomainLicenseTypeRequest, ChangeDomainLicenseTypeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String domainId = null;
        private ChangeDomainLicenseTypeDetails changeDomainLicenseTypeDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder changeDomainLicenseTypeDetails(ChangeDomainLicenseTypeDetails changeDomainLicenseTypeDetails) {
            this.changeDomainLicenseTypeDetails = changeDomainLicenseTypeDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeDomainLicenseTypeRequest o) {
            this.domainId(o.getDomainId());
            this.changeDomainLicenseTypeDetails(o.getChangeDomainLicenseTypeDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeDomainLicenseTypeRequest build() {
            ChangeDomainLicenseTypeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeDomainLicenseTypeDetails body) {
            this.changeDomainLicenseTypeDetails(body);
            return this;
        }

        public ChangeDomainLicenseTypeRequest buildWithoutInvocationCallback() {
            ChangeDomainLicenseTypeRequest request = new ChangeDomainLicenseTypeRequest();
            request.domainId = this.domainId;
            request.changeDomainLicenseTypeDetails = this.changeDomainLicenseTypeDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

