/*
 * Decompiled with CFR 0.152.
 */
package net.vieiro.toml;

import java.io.IOException;
import java.io.Writer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

final class TOMLJSON {
    TOMLJSON() {
    }

    static void write(Object object, Writer out, boolean quotes) throws IOException {
        if (object == null) {
            out.write("null");
        } else if (object instanceof Map) {
            TOMLJSON.writeMap((Map)object, out);
        } else if (object instanceof List) {
            TOMLJSON.writeList((List)object, out);
        } else {
            TOMLJSON.writeLiteral(object, out, quotes);
        }
    }

    private static void writeMap(Map<Object, Object> table, Writer out) throws IOException {
        out.write(123);
        int i = 0;
        int n = table.entrySet().size();
        for (Map.Entry<Object, Object> entry : table.entrySet()) {
            TOMLJSON.write(entry.getKey(), out, true);
            out.write(58);
            TOMLJSON.write(entry.getValue(), out, false);
            if (i < n - 1) {
                out.write(44);
            }
            ++i;
        }
        out.write(125);
    }

    private static void writeList(List<Object> list, Writer out) throws IOException {
        out.write(91);
        int n = list.size();
        for (int i = 0; i < list.size(); ++i) {
            TOMLJSON.write(list.get(i), out, false);
            if (i >= n - 1) continue;
            out.write(44);
        }
        out.write(93);
    }

    private static void writeLiteral(Object o, Writer out, boolean quotes) throws IOException {
        if (quotes) {
            out.write(34);
        }
        if (o instanceof String) {
            if (!quotes) {
                out.write(34);
            }
            TOMLJSON.writeString((String)o, out);
            if (!quotes) {
                out.write(34);
            }
        } else if (o instanceof Long) {
            out.write(Long.toString((Long)o));
        } else if (o instanceof Double) {
            Double d = (Double)o;
            if (Double.isNaN(d)) {
                out.write("null");
            } else if (d.isInfinite()) {
                out.write(d == Double.POSITIVE_INFINITY ? "null" : "null");
            } else {
                out.write(Double.toString(d));
            }
        } else if (o instanceof Boolean) {
            out.write(Boolean.toString((Boolean)o));
        } else if (o instanceof OffsetDateTime) {
            if (!quotes) {
                out.write(34);
            }
            out.write(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format((OffsetDateTime)o));
            if (!quotes) {
                out.write(34);
            }
        } else if (o instanceof LocalDateTime) {
            if (!quotes) {
                out.write(34);
            }
            out.write(DateTimeFormatter.ISO_LOCAL_DATE_TIME.format((LocalDateTime)o));
            if (!quotes) {
                out.write(34);
            }
        } else if (o instanceof LocalDate) {
            if (!quotes) {
                out.write(34);
            }
            out.write(DateTimeFormatter.ISO_LOCAL_DATE.format((LocalDate)o));
            if (!quotes) {
                out.write(34);
            }
        } else if (o instanceof LocalTime) {
            if (!quotes) {
                out.write(34);
            }
            out.write(DateTimeFormatter.ISO_LOCAL_TIME.format((LocalTime)o));
            if (!quotes) {
                out.write(34);
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (quotes) {
            out.write(34);
        }
    }

    private static void writeString(String s, Writer sb) throws IOException {
        int len = s.length();
        block10: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.write("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.write("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.write("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.write("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.write("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.write("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.write("\\t");
                    continue block10;
                }
                case '/': {
                    sb.write("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.write("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.write(48);
                        }
                        sb.write(ss.toUpperCase());
                        continue block10;
                    }
                    sb.write(ch);
                }
            }
        }
    }
}

