/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.common;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.util.NbBundle;

public class CommonDDAccess {
    public static final String DOT = ".";
    public static final String COMMON_API = "org.netbeans.modules.j2ee.dd.api.common.";
    public static final String SERVLET_2_4 = "2_4";
    public static final String WEB_API = "org.netbeans.modules.j2ee.dd.api.web.";
    public static final String WEB_PACKAGE_PREFIX = "org.netbeans.modules.j2ee.dd.impl.web.model_";
    public static final String APP_1_4 = "1_4";
    public static final String APP_API = "org.netbeans.modules.j2ee.dd.api.application.";
    public static final String APP_PACKAGE_PREFIX = "org.netbeans.modules.j2ee.dd.impl.application.model_";
    public static final String EJB_2_1 = "2_1";
    public static final String EJB_API = "org.netbeans.modules.j2ee.dd.api.ejb.";
    public static final String EJB_PACKAGE_PREFIX = "org.netbeans.modules.j2ee.dd.impl.ejb.model_";
    private static Set COMMON_BEANS = new HashSet();

    public static BaseBean newBean(CommonDDBean parent, String beanName, String pkgName) throws ClassNotFoundException {
        beanName = CommonDDAccess.getImplementationBeanName(parent, beanName, pkgName);
        try {
            Class<?> beanClass = Class.forName(pkgName + DOT + beanName);
            return (BaseBean)beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e;
            }
            e.printStackTrace();
            throw new RuntimeException(NbBundle.getMessage(CommonDDAccess.class, (String)"MSG_COMMONDDACCESS_ERROR", (Object)"newBean", (Object)(", package = " + pkgName + ", beanName = " + beanName), (Object)(e + ": " + e.getMessage())));
        }
    }

    public static void addBean(CommonDDBean parent, CommonDDBean child, String beanName, String pkgName) {
        beanName = CommonDDAccess.getImplementationBeanName(parent, beanName, pkgName);
        String apiPrefix = CommonDDAccess.getAPIPrefix(beanName, pkgName);
        try {
            Class<?> p = parent.getClass();
            Class<?> ch = Class.forName(apiPrefix + beanName);
            Method setter = null;
            try {
                setter = p.getMethod("set" + beanName, ch);
                setter.invoke((Object)parent, child);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (setter == null) {
                setter = p.getMethod("add" + CommonDDAccess.getNameForMethod(parent, beanName), ch);
                setter.invoke((Object)parent, child);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(NbBundle.getMessage(CommonDDAccess.class, (String)"MSG_COMMONDDACCESS_ERROR", (Object)"addBean", (Object)(", package = " + pkgName + ", beanName = " + beanName), (Object)(e + ": " + e.getMessage())));
        }
    }

    private static String getImplementationBeanName(CommonDDBean parent, String beanName, String pkgName) {
        if (beanName.equals("Session") || beanName.equals("Entity") || beanName.equals("MessageDriven")) {
            return beanName + "Bean";
        }
        return beanName;
    }

    private static String getAPIPrefix(String beanName, String pkgName) {
        if (COMMON_BEANS.contains(beanName)) {
            return COMMON_API;
        }
        if (pkgName.startsWith(EJB_PACKAGE_PREFIX)) {
            return EJB_API;
        }
        if (pkgName.startsWith(WEB_PACKAGE_PREFIX)) {
            return WEB_API;
        }
        if (pkgName.startsWith(APP_PACKAGE_PREFIX)) {
            return APP_API;
        }
        assert (false) : "Invalid package prefix:" + pkgName;
        return "";
    }

    public static BaseBean findBeanByName(BaseBean parent, String beanProperty, String nameProperty, String value) {
        Class<?> c = parent.getClass();
        try {
            Method getter = c.getMethod("get" + CommonDDAccess.getNameForMethod((CommonDDBean)parent, beanProperty), new Class[0]);
            Object result = getter.invoke((Object)parent, new Object[0]);
            if (result == null) {
                return null;
            }
            if (result instanceof BaseBean) {
                return null;
            }
            BaseBean[] beans = (BaseBean[])result;
            for (int i = 0; i < beans.length; ++i) {
                Class<?> c1 = beans[i].getClass();
                Method getter1 = c1.getMethod("get" + nameProperty, new Class[0]);
                Object result1 = getter1.invoke((Object)beans[i], new Object[0]);
                if (!(result1 instanceof String) || !value.equals((String)result1)) continue;
                return beans[i];
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(NbBundle.getMessage(CommonDDAccess.class, (String)"MSG_COMMONDDACCESS_ERROR", (Object)"getBeanByName", (Object)("parent = " + parent + ", beanProperty = " + beanProperty + ", nameProperty = " + nameProperty + ", value = " + value), (Object)(e + ": " + e.getMessage())));
        }
    }

    private static String getNameForMethod(CommonDDBean parent, String beanName) {
        if ("InitParam".equals(beanName) && parent instanceof WebApp) {
            return "ContextParam";
        }
        if ("ServiceRefHandler".equals(beanName)) {
            return "Handler";
        }
        return beanName;
    }

    static {
        COMMON_BEANS.add("Icon");
        COMMON_BEANS.add("InitParam");
        COMMON_BEANS.add("EnvEntry");
        COMMON_BEANS.add("EjbRef");
        COMMON_BEANS.add("EjbLocalRef");
        COMMON_BEANS.add("ResourceRef");
        COMMON_BEANS.add("ResourceEnvRef");
        COMMON_BEANS.add("ServiceRef");
        COMMON_BEANS.add("Handler");
        COMMON_BEANS.add("PortComponentRef");
        COMMON_BEANS.add("MessageDestination");
        COMMON_BEANS.add("MessageDestinationRef");
        COMMON_BEANS.add("SecurityRole");
        COMMON_BEANS.add("SecurityRoleRef");
    }
}

