/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class SwitchoverAutonomousDatabaseRequest
extends BmcRequest<Void> {
    private String autonomousDatabaseId;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;
    private String peerDbId;

    public String getAutonomousDatabaseId() {
        return this.autonomousDatabaseId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPeerDbId() {
        return this.peerDbId;
    }

    public Builder toBuilder() {
        return new Builder().autonomousDatabaseId(this.autonomousDatabaseId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).peerDbId(this.peerDbId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",autonomousDatabaseId=").append(String.valueOf(this.autonomousDatabaseId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",peerDbId=").append(String.valueOf(this.peerDbId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SwitchoverAutonomousDatabaseRequest)) {
            return false;
        }
        SwitchoverAutonomousDatabaseRequest other = (SwitchoverAutonomousDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.autonomousDatabaseId, other.autonomousDatabaseId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.peerDbId, other.peerDbId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.autonomousDatabaseId == null ? 43 : this.autonomousDatabaseId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.peerDbId == null ? 43 : this.peerDbId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SwitchoverAutonomousDatabaseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String autonomousDatabaseId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String peerDbId = null;

        public Builder autonomousDatabaseId(String autonomousDatabaseId) {
            this.autonomousDatabaseId = autonomousDatabaseId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder peerDbId(String peerDbId) {
            this.peerDbId = peerDbId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SwitchoverAutonomousDatabaseRequest o) {
            this.autonomousDatabaseId(o.getAutonomousDatabaseId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.peerDbId(o.getPeerDbId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SwitchoverAutonomousDatabaseRequest build() {
            SwitchoverAutonomousDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SwitchoverAutonomousDatabaseRequest buildWithoutInvocationCallback() {
            SwitchoverAutonomousDatabaseRequest request = new SwitchoverAutonomousDatabaseRequest();
            request.autonomousDatabaseId = this.autonomousDatabaseId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.peerDbId = this.peerDbId;
            return request;
        }
    }
}

