/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetVmClusterPatchHistoryEntryRequest
extends BmcRequest<Void> {
    private String vmClusterId;
    private String patchHistoryEntryId;

    public String getVmClusterId() {
        return this.vmClusterId;
    }

    public String getPatchHistoryEntryId() {
        return this.patchHistoryEntryId;
    }

    public Builder toBuilder() {
        return new Builder().vmClusterId(this.vmClusterId).patchHistoryEntryId(this.patchHistoryEntryId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",vmClusterId=").append(String.valueOf(this.vmClusterId));
        sb.append(",patchHistoryEntryId=").append(String.valueOf(this.patchHistoryEntryId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVmClusterPatchHistoryEntryRequest)) {
            return false;
        }
        GetVmClusterPatchHistoryEntryRequest other = (GetVmClusterPatchHistoryEntryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.vmClusterId, other.vmClusterId) && Objects.equals(this.patchHistoryEntryId, other.patchHistoryEntryId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vmClusterId == null ? 43 : this.vmClusterId.hashCode());
        result = result * 59 + (this.patchHistoryEntryId == null ? 43 : this.patchHistoryEntryId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVmClusterPatchHistoryEntryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String vmClusterId = null;
        private String patchHistoryEntryId = null;

        public Builder vmClusterId(String vmClusterId) {
            this.vmClusterId = vmClusterId;
            return this;
        }

        public Builder patchHistoryEntryId(String patchHistoryEntryId) {
            this.patchHistoryEntryId = patchHistoryEntryId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVmClusterPatchHistoryEntryRequest o) {
            this.vmClusterId(o.getVmClusterId());
            this.patchHistoryEntryId(o.getPatchHistoryEntryId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVmClusterPatchHistoryEntryRequest build() {
            GetVmClusterPatchHistoryEntryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetVmClusterPatchHistoryEntryRequest buildWithoutInvocationCallback() {
            GetVmClusterPatchHistoryEntryRequest request = new GetVmClusterPatchHistoryEntryRequest();
            request.vmClusterId = this.vmClusterId;
            request.patchHistoryEntryId = this.patchHistoryEntryId;
            return request;
        }
    }
}

