/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExternalPluggableDatabaseRequest
extends BmcRequest<Void> {
    private String externalPluggableDatabaseId;
    private String opcRequestId;

    public String getExternalPluggableDatabaseId() {
        return this.externalPluggableDatabaseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().externalPluggableDatabaseId(this.externalPluggableDatabaseId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",externalPluggableDatabaseId=").append(String.valueOf(this.externalPluggableDatabaseId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExternalPluggableDatabaseRequest)) {
            return false;
        }
        GetExternalPluggableDatabaseRequest other = (GetExternalPluggableDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.externalPluggableDatabaseId, other.externalPluggableDatabaseId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalPluggableDatabaseId == null ? 43 : this.externalPluggableDatabaseId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExternalPluggableDatabaseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String externalPluggableDatabaseId = null;
        private String opcRequestId = null;

        public Builder externalPluggableDatabaseId(String externalPluggableDatabaseId) {
            this.externalPluggableDatabaseId = externalPluggableDatabaseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalPluggableDatabaseRequest o) {
            this.externalPluggableDatabaseId(o.getExternalPluggableDatabaseId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalPluggableDatabaseRequest build() {
            GetExternalPluggableDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExternalPluggableDatabaseRequest buildWithoutInvocationCallback() {
            GetExternalPluggableDatabaseRequest request = new GetExternalPluggableDatabaseRequest();
            request.externalPluggableDatabaseId = this.externalPluggableDatabaseId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

