/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.AutonomousContainerDatabaseBackupConfig;
import com.oracle.bmc.database.model.MaintenanceWindow;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateAutonomousContainerDatabaseDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="patchModel")
    private final PatchModel patchModel;
    @JsonProperty(value="maintenanceWindowDetails")
    private final MaintenanceWindow maintenanceWindowDetails;
    @JsonProperty(value="standbyMaintenanceBufferInDays")
    private final Integer standbyMaintenanceBufferInDays;
    @JsonProperty(value="versionPreference")
    private final VersionPreference versionPreference;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="backupConfig")
    private final AutonomousContainerDatabaseBackupConfig backupConfig;

    @Deprecated
    @ConstructorProperties(value={"displayName", "patchModel", "maintenanceWindowDetails", "standbyMaintenanceBufferInDays", "versionPreference", "freeformTags", "definedTags", "backupConfig"})
    public UpdateAutonomousContainerDatabaseDetails(String displayName, PatchModel patchModel, MaintenanceWindow maintenanceWindowDetails, Integer standbyMaintenanceBufferInDays, VersionPreference versionPreference, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, AutonomousContainerDatabaseBackupConfig backupConfig) {
        this.displayName = displayName;
        this.patchModel = patchModel;
        this.maintenanceWindowDetails = maintenanceWindowDetails;
        this.standbyMaintenanceBufferInDays = standbyMaintenanceBufferInDays;
        this.versionPreference = versionPreference;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.backupConfig = backupConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public PatchModel getPatchModel() {
        return this.patchModel;
    }

    public MaintenanceWindow getMaintenanceWindowDetails() {
        return this.maintenanceWindowDetails;
    }

    public Integer getStandbyMaintenanceBufferInDays() {
        return this.standbyMaintenanceBufferInDays;
    }

    public VersionPreference getVersionPreference() {
        return this.versionPreference;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public AutonomousContainerDatabaseBackupConfig getBackupConfig() {
        return this.backupConfig;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateAutonomousContainerDatabaseDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", patchModel=").append(String.valueOf((Object)this.patchModel));
        sb.append(", maintenanceWindowDetails=").append(String.valueOf((Object)this.maintenanceWindowDetails));
        sb.append(", standbyMaintenanceBufferInDays=").append(String.valueOf(this.standbyMaintenanceBufferInDays));
        sb.append(", versionPreference=").append(String.valueOf((Object)this.versionPreference));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", backupConfig=").append(String.valueOf((Object)this.backupConfig));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAutonomousContainerDatabaseDetails)) {
            return false;
        }
        UpdateAutonomousContainerDatabaseDetails other = (UpdateAutonomousContainerDatabaseDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.patchModel, (Object)other.patchModel) && Objects.equals((Object)this.maintenanceWindowDetails, (Object)other.maintenanceWindowDetails) && Objects.equals(this.standbyMaintenanceBufferInDays, other.standbyMaintenanceBufferInDays) && Objects.equals((Object)this.versionPreference, (Object)other.versionPreference) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.backupConfig, (Object)other.backupConfig) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.patchModel == null ? 43 : this.patchModel.hashCode());
        result = result * 59 + (this.maintenanceWindowDetails == null ? 43 : this.maintenanceWindowDetails.hashCode());
        result = result * 59 + (this.standbyMaintenanceBufferInDays == null ? 43 : this.standbyMaintenanceBufferInDays.hashCode());
        result = result * 59 + (this.versionPreference == null ? 43 : this.versionPreference.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.backupConfig == null ? 43 : this.backupConfig.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum VersionPreference implements BmcEnum
    {
        NextReleaseUpdate("NEXT_RELEASE_UPDATE"),
        LatestReleaseUpdate("LATEST_RELEASE_UPDATE");

        private final String value;
        private static Map<String, VersionPreference> map;

        private VersionPreference(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static VersionPreference create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid VersionPreference: " + key);
        }

        static {
            map = new HashMap<String, VersionPreference>();
            for (VersionPreference v : VersionPreference.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PatchModel implements BmcEnum
    {
        ReleaseUpdates("RELEASE_UPDATES"),
        ReleaseUpdateRevisions("RELEASE_UPDATE_REVISIONS");

        private final String value;
        private static Map<String, PatchModel> map;

        private PatchModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PatchModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PatchModel: " + key);
        }

        static {
            map = new HashMap<String, PatchModel>();
            for (PatchModel v : PatchModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="patchModel")
        private PatchModel patchModel;
        @JsonProperty(value="maintenanceWindowDetails")
        private MaintenanceWindow maintenanceWindowDetails;
        @JsonProperty(value="standbyMaintenanceBufferInDays")
        private Integer standbyMaintenanceBufferInDays;
        @JsonProperty(value="versionPreference")
        private VersionPreference versionPreference;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="backupConfig")
        private AutonomousContainerDatabaseBackupConfig backupConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder patchModel(PatchModel patchModel) {
            this.patchModel = patchModel;
            this.__explicitlySet__.add("patchModel");
            return this;
        }

        public Builder maintenanceWindowDetails(MaintenanceWindow maintenanceWindowDetails) {
            this.maintenanceWindowDetails = maintenanceWindowDetails;
            this.__explicitlySet__.add("maintenanceWindowDetails");
            return this;
        }

        public Builder standbyMaintenanceBufferInDays(Integer standbyMaintenanceBufferInDays) {
            this.standbyMaintenanceBufferInDays = standbyMaintenanceBufferInDays;
            this.__explicitlySet__.add("standbyMaintenanceBufferInDays");
            return this;
        }

        public Builder versionPreference(VersionPreference versionPreference) {
            this.versionPreference = versionPreference;
            this.__explicitlySet__.add("versionPreference");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder backupConfig(AutonomousContainerDatabaseBackupConfig backupConfig) {
            this.backupConfig = backupConfig;
            this.__explicitlySet__.add("backupConfig");
            return this;
        }

        public UpdateAutonomousContainerDatabaseDetails build() {
            UpdateAutonomousContainerDatabaseDetails model = new UpdateAutonomousContainerDatabaseDetails(this.displayName, this.patchModel, this.maintenanceWindowDetails, this.standbyMaintenanceBufferInDays, this.versionPreference, this.freeformTags, this.definedTags, this.backupConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateAutonomousContainerDatabaseDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("patchModel")) {
                this.patchModel(model.getPatchModel());
            }
            if (model.wasPropertyExplicitlySet("maintenanceWindowDetails")) {
                this.maintenanceWindowDetails(model.getMaintenanceWindowDetails());
            }
            if (model.wasPropertyExplicitlySet("standbyMaintenanceBufferInDays")) {
                this.standbyMaintenanceBufferInDays(model.getStandbyMaintenanceBufferInDays());
            }
            if (model.wasPropertyExplicitlySet("versionPreference")) {
                this.versionPreference(model.getVersionPreference());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("backupConfig")) {
                this.backupConfig(model.getBackupConfig());
            }
            return this;
        }
    }
}

