/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RestoreDatabaseDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="databaseSCN")
    private final String databaseSCN;
    @JsonProperty(value="timestamp")
    private final Date timestamp;
    @JsonProperty(value="latest")
    private final Boolean latest;

    @Deprecated
    @ConstructorProperties(value={"databaseSCN", "timestamp", "latest"})
    public RestoreDatabaseDetails(String databaseSCN, Date timestamp, Boolean latest) {
        this.databaseSCN = databaseSCN;
        this.timestamp = timestamp;
        this.latest = latest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDatabaseSCN() {
        return this.databaseSCN;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Boolean getLatest() {
        return this.latest;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RestoreDatabaseDetails(");
        sb.append("super=").append(super.toString());
        sb.append("databaseSCN=").append(String.valueOf(this.databaseSCN));
        sb.append(", timestamp=").append(String.valueOf(this.timestamp));
        sb.append(", latest=").append(String.valueOf(this.latest));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestoreDatabaseDetails)) {
            return false;
        }
        RestoreDatabaseDetails other = (RestoreDatabaseDetails)((Object)o);
        return Objects.equals(this.databaseSCN, other.databaseSCN) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.latest, other.latest) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.databaseSCN == null ? 43 : this.databaseSCN.hashCode());
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + (this.latest == null ? 43 : this.latest.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="databaseSCN")
        private String databaseSCN;
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonProperty(value="latest")
        private Boolean latest;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder databaseSCN(String databaseSCN) {
            this.databaseSCN = databaseSCN;
            this.__explicitlySet__.add("databaseSCN");
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Builder latest(Boolean latest) {
            this.latest = latest;
            this.__explicitlySet__.add("latest");
            return this;
        }

        public RestoreDatabaseDetails build() {
            RestoreDatabaseDetails model = new RestoreDatabaseDetails(this.databaseSCN, this.timestamp, this.latest);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RestoreDatabaseDetails model) {
            if (model.wasPropertyExplicitlySet("databaseSCN")) {
                this.databaseSCN(model.getDatabaseSCN());
            }
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            if (model.wasPropertyExplicitlySet("latest")) {
                this.latest(model.getLatest());
            }
            return this;
        }
    }
}

